/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.device.DeviceNotAvailableException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class RunNotifierWrapper
extends RunNotifier {
    private DeviceNotAvailableException mDnae;
    private RunNotifier notifier;

    public RunNotifierWrapper(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void fireTestFailure(Failure failure) {
        this.notifier.fireTestFailure(failure);
        if (failure.getException() instanceof DeviceNotAvailableException) {
            this.mDnae = (DeviceNotAvailableException)failure.getException();
        }
    }

    public void fireTestAssumptionFailed(Failure failure) {
        this.notifier.fireTestAssumptionFailed(failure);
    }

    public void fireTestFinished(Description description) {
        this.notifier.fireTestFinished(description);
    }

    public void fireTestStarted(Description description) {
        this.notifier.fireTestStarted(description);
    }

    public void fireTestIgnored(Description description) {
        this.notifier.fireTestIgnored(description);
    }

    public DeviceNotAvailableException getDeviceNotAvailableException() {
        return this.mDnae;
    }
}

