/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.python;

import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.PythonUnitTestResultParser;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SubprocessTestResultsParser;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="python-host")
public class PythonBinaryHostTest
implements IRemoteTest,
ITestFilterReceiver {
    protected static final String ANDROID_SERIAL_VAR = "ANDROID_SERIAL";
    protected static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    protected static final String PATH_VAR = "PATH";
    protected static final long PATH_TIMEOUT_MS = 60000L;
    static final String USE_TEST_OUTPUT_FILE_OPTION = "use-test-output-file";
    static final String TEST_OUTPUT_FILE_FLAG = "test-output-file";
    private static final String PYTHON_LOG_STDOUT_FORMAT = "%s-stdout";
    private static final String PYTHON_LOG_STDERR_FORMAT = "%s-stderr";
    private static final String PYTHON_LOG_TEST_OUTPUT_FORMAT = "%s-test-output";
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    private String mLdLibraryPath = null;
    @Option(name="par-file-name", description="The binary names inside the build info to run.")
    private Set<String> mBinaryNames = new HashSet<String>();
    @Option(name="python-binaries", description="The full path to a runnable python binary. Can be repeated.")
    private Set<File> mBinaries = new HashSet<File>();
    @Option(name="test-timeout", description="Timeout for a single par file to terminate.", isTimeVal=true)
    private long mTestTimeout = 20000L;
    @Option(name="inject-serial-option", description="Whether or not to pass a -s <serialnumber> option to the binary")
    private boolean mInjectSerial = false;
    @Option(name="inject-android-serial", description="Whether or not to pass a ANDROID_SERIAL variable to the process.")
    private boolean mInjectAndroidSerialVar = true;
    @Option(name="python-options", description="Option string to be passed to the binary when running")
    private List<String> mTestOptions = new ArrayList<String>();
    @Option(name="use-test-output-file", description="Whether the test should write results to the file specified via the --test-output-file flag instead of stderr which could contain spurious messages that break result parsing. Using this option requires that the Python test have the necessary logic to accept the flag and write results in the expected format.")
    private boolean mUseTestOutputFile = false;
    private TestInformation mTestInfo;
    private IRunUtil mRunUtil;

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestInfo = testInfo;
        File testDir = this.mTestInfo.executionFiles().get(ExecutionFiles.FilesKey.HOST_TESTS_DIRECTORY);
        if (testDir == null || !testDir.exists()) {
            testDir = this.mTestInfo.executionFiles().get(ExecutionFiles.FilesKey.TESTS_DIRECTORY);
        }
        if (testDir != null && testDir.exists()) {
            File lib64Dir;
            File libDir = new File(testDir, "lib");
            ArrayList<String> ldLibraryPath = new ArrayList<String>();
            if (libDir.exists()) {
                ldLibraryPath.add(libDir.getAbsolutePath());
            }
            if ((lib64Dir = new File(testDir, "lib64")).exists()) {
                ldLibraryPath.add(lib64Dir.getAbsolutePath());
            }
            if (!ldLibraryPath.isEmpty()) {
                this.mLdLibraryPath = Joiner.on(":").join(ldLibraryPath);
            }
        }
        List<File> pythonFilesList = this.findParFiles();
        for (File pyFile : pythonFilesList) {
            if (!pyFile.exists()) {
                LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{pyFile.getAbsolutePath()});
                continue;
            }
            pyFile.setExecutable(true);
            this.runSinglePythonFile(listener, testInfo, pyFile);
        }
    }

    private List<File> findParFiles() {
        File testsDir = null;
        if (this.mTestInfo.getBuildInfo() instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mTestInfo.getBuildInfo()).getTestsDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String parFileName : this.mBinaryNames) {
            File res = null;
            if (testsDir != null) {
                res = FileUtil.findFile((File)testsDir, (String)parFileName);
            }
            if (res == null) {
                throw new RuntimeException(String.format("Couldn't find a par file %s", parFileName));
            }
            files.add(res);
        }
        files.addAll(this.mBinaries);
        return files;
    }

    private void runSinglePythonFile(ITestInvocationListener listener, TestInformation testInfo, File pyFile) {
        block33: {
            String adbPath;
            File updatedAdb;
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(pyFile.getAbsolutePath());
            if (!(this.mTestInfo.getDevice().getIDevice() instanceof StubDevice) && this.mInjectSerial) {
                commandLine.add("-s");
                commandLine.add(this.mTestInfo.getDevice().getSerialNumber());
            }
            if (this.mLdLibraryPath != null) {
                this.getRunUtil().setEnvVariable(LD_LIBRARY_PATH, this.mLdLibraryPath);
            }
            if (this.mInjectAndroidSerialVar) {
                this.getRunUtil().setEnvVariable(ANDROID_SERIAL_VAR, this.mTestInfo.getDevice().getSerialNumber());
            }
            File tempTestOutputFile = null;
            if (this.mUseTestOutputFile) {
                try {
                    tempTestOutputFile = FileUtil.createTempFile((String)"python-test-output", (String)".txt");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                commandLine.add("--test-output-file");
                commandLine.add(tempTestOutputFile.getAbsolutePath());
            }
            if ((updatedAdb = testInfo.executionFiles().get(ExecutionFiles.FilesKey.ADB_BINARY)) == null && !(adbPath = this.getAdbPath()).equals("adb") && !(updatedAdb = new File(adbPath)).exists()) {
                updatedAdb = null;
            }
            if (updatedAdb != null) {
                LogUtil.CLog.d((String)"Testing with adb binary at: %s", (Object[])new Object[]{updatedAdb});
                CommandResult pathResult = this.getRunUtil().runTimedCmd(60000L, new String[]{"/bin/bash", "-c", "echo $PATH"});
                if (!CommandStatus.SUCCESS.equals((Object)pathResult.getStatus())) {
                    throw new RuntimeException(String.format("Failed to get the $PATH. status: %s, stdout: %s, stderr: %s", pathResult.getStatus(), pathResult.getStdout(), pathResult.getStderr()));
                }
                String path = String.format("%s:%s", updatedAdb.getParentFile().getAbsolutePath(), pathResult.getStdout().trim());
                LogUtil.CLog.d((String)"Using $PATH with updated adb: %s", (Object[])new Object[]{path});
                this.getRunUtil().setEnvVariable(PATH_VAR, path);
                CommandResult versionRes = this.getRunUtil().runTimedCmd(60000L, new String[]{"adb", "version"});
                LogUtil.CLog.d((String)"%s", (Object[])new Object[]{versionRes.getStdout()});
                LogUtil.CLog.d((String)"%s", (Object[])new Object[]{versionRes.getStderr()});
            }
            commandLine.addAll(this.mTestOptions);
            CommandResult result = this.getRunUtil().runTimedCmd(this.mTestTimeout, commandLine.toArray(new String[0]));
            String runName = pyFile.getName();
            PythonForwarder forwarder = new PythonForwarder(listener, runName);
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                LogUtil.CLog.e((String)"Something went wrong when running the python binary:\nstdout: %s\nstderr:%s", (Object[])new Object[]{result.getStdout(), result.getStderr()});
            }
            if (result.getStdout() != null) {
                try (ByteArrayInputStreamSource data = new ByteArrayInputStreamSource(result.getStdout().getBytes());){
                    listener.testLog(String.format(PYTHON_LOG_STDOUT_FORMAT, runName), LogDataType.TEXT, (InputStreamSource)data);
                }
            }
            File stderrFile = null;
            try {
                stderrFile = FileUtil.createTempFile((String)"python-res", (String)".txt");
                FileUtil.writeToFile((String)result.getStderr(), (File)stderrFile);
                PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_STDERR_FORMAT, runName), stderrFile);
                File testOutputFile = stderrFile;
                String testOutput = result.getStderr();
                if (this.mUseTestOutputFile) {
                    testOutputFile = tempTestOutputFile;
                    testOutput = FileUtil.readStringFromFile((File)testOutputFile);
                    PythonBinaryHostTest.testLogFile(listener, String.format(PYTHON_LOG_TEST_OUTPUT_FORMAT, runName), testOutputFile);
                }
                if (!testOutput.contains("TEST_RUN_STARTED")) {
                    PythonUnitTestResultParser pythonParser = new PythonUnitTestResultParser(Arrays.asList(new ITestInvocationListener[]{forwarder}), "python-run", this.mIncludeFilters, this.mExcludeFilters);
                    pythonParser.processNewLines(testOutput.split("\n"));
                    break block33;
                }
                if (!this.mIncludeFilters.isEmpty() || !this.mExcludeFilters.isEmpty()) {
                    throw new RuntimeException("Non-unittest python test does not support using filters in PythonBinaryHostTest. Please use test runner ExecutableHostTest instead.");
                }
                try (SubprocessTestResultsParser parser = new SubprocessTestResultsParser((ITestInvocationListener)forwarder, this.mTestInfo.getContext());){
                    parser.parseFile(testOutputFile);
                }
            }
            catch (RuntimeException e) {
                StringBuilder message = new StringBuilder();
                Formatter formatter = new Formatter(message);
                formatter.format("Failed to parse the python logs: %s. Please ensure that verbosity of output is high enough to be parsed.", e.getMessage());
                if (this.mUseTestOutputFile) {
                    formatter.format(" Make sure that your test writes its output to the file specified by the --%s flag and that its contents (%s) are in the format expected by the test runner.", TEST_OUTPUT_FILE_FLAG, String.format(PYTHON_LOG_TEST_OUTPUT_FORMAT, runName));
                }
                this.reportFailure(listener, runName, message.toString());
                LogUtil.CLog.e((Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                FileUtil.deleteFile((File)stderrFile);
                FileUtil.deleteFile((File)tempTestOutputFile);
            }
        }
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }

    String getAdbPath() {
        return GlobalConfiguration.getDeviceManagerInstance().getAdbPath();
    }

    private void reportFailure(ITestInvocationListener listener, String runName, String errorMessage) {
        listener.testRunStarted(runName, 0);
        FailureDescription description = FailureDescription.create((String)errorMessage, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
        listener.testRunFailed(description);
        listener.testRunEnded(0L, new HashMap());
    }

    private static void testLogFile(ITestInvocationListener listener, String dataName, File f) {
        try (FileInputStreamSource data = new FileInputStreamSource(f);){
            listener.testLog(dataName, LogDataType.TEXT, (InputStreamSource)data);
        }
    }

    public static class PythonForwarder
    extends ResultForwarder {
        private String mRunName;

        public PythonForwarder(ITestInvocationListener listener, String name) {
            super(new ITestInvocationListener[]{listener});
            this.mRunName = name;
        }

        public void testRunStarted(String runName, int testCount) {
            this.testRunStarted(runName, testCount, 0);
        }

        public void testRunStarted(String runName, int testCount, int attempt) {
            this.testRunStarted(runName, testCount, attempt, System.currentTimeMillis());
        }

        public void testRunStarted(String runName, int testCount, int attempt, long startTime) {
            super.testRunStarted(this.mRunName, testCount, attempt, startTime);
        }
    }
}

