/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.rust.RustTestBase;
import com.android.tradefed.testtype.rust.RustTestResultParser;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="rust-host")
public class RustBinaryHostTest
extends RustTestBase
implements IBuildReceiver {
    static final String RUST_LOG_STDERR_FORMAT = "%s-stderr";
    @Option(name="test-file", description="The test file name or file path.")
    private Set<String> mBinaryNames = new HashSet<String>();
    private IBuildInfo mBuildInfo;
    private IRunUtil mRunUtil;

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        List<File> rustFilesList = this.findFiles();
        for (File file : rustFilesList) {
            if (!file.exists()) {
                LogUtil.CLog.d((String)"ignoring %s which doesn't look like a test file.", (Object[])new Object[]{file.getAbsolutePath()});
                continue;
            }
            file.setExecutable(true);
            this.runSingleRustFile(listener, file);
        }
    }

    private List<File> findFiles() {
        File testsDir = null;
        if (this.mBuildInfo instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mBuildInfo).getTestsDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : this.mBinaryNames) {
            File res = null;
            File filePath = new File(fileName);
            String paths = "";
            if (filePath.isAbsolute()) {
                res = filePath;
            } else {
                if (testsDir == null) {
                    throw new RuntimeException(String.format("Cannot find %s without test directory", fileName));
                }
                paths = testsDir + "\n";
                String baseName = filePath.getName();
                if (!baseName.equals(fileName)) {
                    try {
                        Set candidates = FileUtil.findFilesObject((File)testsDir, (String)baseName);
                        for (File f : candidates) {
                            paths = paths + String.format("  found: %s\n", f.getPath());
                            if (!f.getPath().endsWith(fileName)) continue;
                            res = f;
                            break;
                        }
                        if (res == null) {
                            LogUtil.CLog.e((String)"Cannot find %s; try to find %s", (Object[])new Object[]{fileName, baseName});
                        }
                    }
                    catch (IOException e) {
                        res = null;
                    }
                }
                if (res == null) {
                    res = FileUtil.findFile((File)testsDir, (String)baseName);
                }
            }
            if (res == null) {
                throw new RuntimeException(String.format("Cannot find %s under %s", fileName, paths));
            }
            files.add(res);
        }
        return files;
    }

    private void runSingleRustFile(ITestInvocationListener listener, File file) {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(file.getAbsolutePath());
        LogUtil.CLog.d((String)("Run single Rust File: " + file.getAbsolutePath()));
        commandLine.addAll(this.mTestOptions);
        this.addFiltersToArgs(commandLine);
        ArrayList<String> listCommandLine = new ArrayList<String>(commandLine);
        listCommandLine.add("--list");
        CommandResult listResult = this.getRunUtil().runTimedCmdSilently(this.mTestTimeout, listCommandLine.toArray(new String[0]));
        int testCount = 0;
        if (listResult.getStatus() == CommandStatus.SUCCESS) {
            try {
                testCount = RustBinaryHostTest.parseTestListCount(listResult.getStdout().split("\n"));
            }
            catch (ParseException e) {
                LogUtil.CLog.w((String)"Parsing test list failed: %s", (Object[])new Object[]{e.getMessage()});
            }
        } else {
            LogUtil.CLog.w((String)"Could not run command '%s' to get test list.", (Object[])new Object[]{String.join((CharSequence)" ", listCommandLine)});
        }
        String runName = file.getName();
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(runName, testCount, 0, startTimeMs);
        CommandResult result = this.getRunUtil().runTimedCmd(this.mTestTimeout, commandLine.toArray(new String[0]));
        long testTimeMs = System.currentTimeMillis() - startTimeMs;
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            String message = String.format("Something went wrong when running the rust binary:Exit Code: %s\nstdout: %s\nstderr: %s", result.getExitCode(), result.getStdout(), result.getStderr());
            FailureDescription failure = FailureDescription.create((String)message, (TestRecordProto.FailureStatus)TestRecordProto.FailureStatus.TEST_FAILURE);
            listener.testRunFailed(failure);
            LogUtil.CLog.e((String)message);
        }
        File resultFile = null;
        try {
            resultFile = FileUtil.createTempFile((String)"rust-res", (String)".txt");
            FileUtil.writeToFile((String)result.getStderr(), (File)resultFile);
            try (FileInputStreamSource data = new FileInputStreamSource(resultFile);){
                listener.testLog(String.format(RUST_LOG_STDERR_FORMAT, runName), LogDataType.TEXT, (InputStreamSource)data);
            }
            String[] lines = result.getStdout().split("\n");
            new RustTestResultParser(listener, runName).processNewLines(lines);
        }
        catch (RuntimeException e) {
            listener.testRunFailed(String.format("Failed to parse the rust test output: %s", e.getMessage()));
            LogUtil.CLog.e((Throwable)e);
        }
        catch (IOException e) {
            listener.testRunFailed(e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            FileUtil.deleteFile((File)resultFile);
            listener.testRunEnded(testTimeMs, new HashMap());
        }
    }

    IRunUtil getRunUtil() {
        if (this.mRunUtil == null) {
            this.mRunUtil = new RunUtil();
        }
        return this.mRunUtil;
    }
}

