/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.NativeCodeCoverageListener;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.testtype.rust.RustTestBase;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.google.common.base.Verify;
import java.io.File;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="rust-device")
public class RustBinaryTest
extends RustTestBase
implements IDeviceTest,
IConfigurationReceiver {
    static final String DEFAULT_TEST_PATH = "/data/local/tmp";
    @Option(name="test-device-path", description="The path on the device where tests are located.")
    private String mTestDevicePath = "/data/local/tmp";
    @Option(name="module-name", description="The name of the test module to run.")
    private String mTestModule = null;
    private IConfiguration mConfiguration = null;
    private ITestDevice mDevice = null;

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setModuleName(String name) {
        this.mTestModule = name;
    }

    public String getTestModule() {
        return this.mTestModule;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mTestDevicePath);
        String testModule = this.getTestModule();
        if (testModule != null) {
            testPath.append("/");
            testPath.append(testModule);
        }
        return testPath.toString();
    }

    private boolean shouldSkipFile(String fullPath) throws DeviceNotAvailableException {
        return fullPath == null || fullPath.isEmpty() || !this.mDevice.isExecutable(fullPath);
    }

    private boolean doRunAllTestsInSubdirectory(String root, ITestDevice testDevice, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (testDevice.isDirectory(root)) {
            LogUtil.CLog.d((String)"Look into rust directory %s on %s", (Object[])new Object[]{root, testDevice.getSerialNumber()});
            boolean found = false;
            for (String child : testDevice.getChildren(root)) {
                LogUtil.CLog.d((String)"Look into child path %s", (Object[])new Object[]{root + "/" + child});
                if (!this.doRunAllTestsInSubdirectory(root + "/" + child, testDevice, listener)) continue;
                found = true;
            }
            return found;
        }
        if (this.shouldSkipFile(root)) {
            LogUtil.CLog.d((String)"Skip rust test %s on %s", (Object[])new Object[]{root, testDevice.getSerialNumber()});
            return false;
        }
        LogUtil.CLog.d((String)"To run rust test %s on %s", (Object[])new Object[]{root, testDevice.getSerialNumber()});
        this.runTest(testDevice, listener, this.createParser(listener, new File(root).getName()), root);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ITestDevice testDevice, ITestInvocationListener listener, IShellOutputReceiver resultParser, String fullPath) throws DeviceNotAvailableException {
        LogUtil.CLog.d((String)("RustBinaryTest runTest: " + fullPath));
        String cmd = this.getCoverageOptions().isCoverageEnabled() ? "GCOV_PREFIX=/data/misc/trace/testcoverage " + fullPath : fullPath;
        cmd = this.addFiltersToCommand(cmd);
        int testCount = 0;
        try {
            String[] testList = testDevice.executeShellCommand(cmd + " --list").split("\n");
            testCount = RustBinaryTest.parseTestListCount(testList);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Could not retrieve tests list from device: %s", (Object[])new Object[]{e.getMessage()});
            throw e;
        }
        catch (ParseException e) {
            LogUtil.CLog.w((String)"Parsing test list failed: %s", (Object[])new Object[]{e.getMessage()});
        }
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(new File(fullPath).getName(), testCount, 0, startTimeMs);
        try {
            testDevice.executeShellCommand(cmd, resultParser, this.mTestTimeout, TimeUnit.MILLISECONDS, 0);
        }
        catch (DeviceNotAvailableException e) {
            listener.testRunFailed(String.format("Device not available: %s", e.getMessage()));
        }
        finally {
            listener.testRunEnded(System.currentTimeMillis() - startTimeMs, new HashMap());
        }
    }

    private void wrongTestPath(String msg, String testPath, ITestInvocationListener listener) {
        LogUtil.CLog.e((String)(msg + testPath));
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(testPath, 1, 0, startTimeMs);
        listener.testRunFailed(msg + testPath);
        listener.testRunEnded(0L, new HashMap());
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        if (!this.mDevice.doesFileExist(testPath)) {
            this.wrongTestPath("Could not find test directory ", testPath, listener);
            return;
        }
        listener = this.addNativeCoverageListenerIfEnabled(listener);
        NativeCodeCoverageFlusher flusher = new NativeCodeCoverageFlusher(this.mDevice, this.getCoverageOptions().getCoverageProcesses());
        if (this.getCoverageOptions().isCoverageEnabled()) {
            Verify.verify(this.mDevice.enableAdbRoot(), "Failed to enable adb root.", new Object[0]);
            flusher.resetCoverage();
            this.mDevice.executeShellCommand("mkdir /data/misc/trace/testcoverage");
        }
        LogUtil.CLog.d((String)("To run tests in directory " + testPath));
        if (!this.doRunAllTestsInSubdirectory(testPath, this.mDevice, listener)) {
            this.wrongTestPath("No test found under ", testPath, listener);
        }
    }

    protected CoverageOptions getCoverageOptions() {
        if (this.mConfiguration != null) {
            return this.mConfiguration.getCoverageOptions();
        }
        return new CoverageOptions();
    }

    private ITestInvocationListener addNativeCoverageListenerIfEnabled(ITestInvocationListener listener) {
        CoverageOptions options = this.getCoverageOptions();
        if (options.isCoverageEnabled() && options.getCoverageToolchains().contains(CoverageOptions.Toolchain.GCOV)) {
            return new NativeCodeCoverageListener(this.mDevice, options, listener);
        }
        return listener;
    }
}

