/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.rust.RustTestResultParser;
import com.google.common.annotations.VisibleForTesting;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="rust-test")
public abstract class RustTestBase
implements IRemoteTest,
ITestFilterReceiver {
    private static final Pattern TEST_LIST_PATTERN = Pattern.compile("(\\d+) tests?, (\\d+) benchmarks?");
    @Option(name="test-options", description="Option string to be passed to the binary when running")
    protected List<String> mTestOptions = new ArrayList<String>();
    @Option(name="test-timeout", description="Timeout for a single test file to terminate.", isTimeVal=true)
    protected long mTestTimeout = 20000L;
    @Option(name="include-filter", description="A substr filter of the test names to run; only the first one is used.")
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="A substr filter of the test names to skip.")
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();

    @VisibleForTesting
    IShellOutputReceiver createParser(ITestInvocationListener listener, String runName) {
        return new RustTestResultParser(listener, runName);
    }

    protected static int parseTestListCount(String[] testList) throws ParseException {
        Matcher matcher;
        int testCount = 0;
        if (testList.length > 0) {
            matcher = TEST_LIST_PATTERN.matcher(testList[testList.length - 1]);
            if (!matcher.matches()) {
                throw new ParseException("Could not match total test/benchmark count output. Does this test use the standard Rust test harness?", 0);
            }
        } else {
            throw new ParseException("Test did not return any output with --list argument. Does this test use the standard Rust test harness?", 0);
        }
        testCount = Integer.parseInt(matcher.group(1));
        return testCount;
    }

    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    private void checkMultipleIncludeFilters() {
        if (this.mIncludeFilters.size() > 1) {
            LogUtil.CLog.e((String)"Found multiple include filters; all except the 1st are ignored.");
        }
    }

    protected void addFiltersToArgs(List<String> args) {
        this.checkMultipleIncludeFilters();
        for (String s : this.mIncludeFilters) {
            args.add(s);
        }
        for (String s : this.mExcludeFilters) {
            args.add("--skip");
            args.add(s);
        }
    }

    protected String addFiltersToCommand(String cmd) {
        if (!this.mIncludeFilters.isEmpty()) {
            this.checkMultipleIncludeFilters();
            cmd = cmd + " " + String.join((CharSequence)" ", this.mIncludeFilters);
        }
        if (!this.mExcludeFilters.isEmpty()) {
            cmd = cmd + " --skip " + String.join((CharSequence)" --skip ", this.mExcludeFilters);
        }
        return cmd;
    }
}

