/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Ordered;
import com.google.common.truth.Subject;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class PrimitiveDoubleArraySubject
extends AbstractArraySubject<PrimitiveDoubleArraySubject, double[]> {
    private static final Correspondence<Double, Number> EXACT_EQUALITY_CORRESPONDENCE = new Correspondence<Double, Number>(){

        @Override
        public boolean compare(Double actual, Number expected) {
            return Double.doubleToLongBits(actual) == Double.doubleToLongBits(PrimitiveDoubleArraySubject.checkedToDouble(expected));
        }

        @Override
        public String toString() {
            return "is exactly equal to";
        }
    };

    PrimitiveDoubleArraySubject(FailureMetadata metadata, @NullableDecl double[] o, @NullableDecl String typeDescription) {
        super(metadata, o, typeDescription);
    }

    @Override
    public void isEqualTo(Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isNotEqualTo(Object expected) {
        super.isNotEqualTo(expected);
    }

    @Deprecated
    public TolerantPrimitiveDoubleArrayComparison hasValuesWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.actual());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveDoubleArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveDoubleArraySubject.this.actualAsString(), tolerance, Iterables.toString(expected), expectedCount, actual.length);
                    return;
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveDoubleArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                    return;
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveDoubleArrayComparison hasValuesNotWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.actual());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveDoubleArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public DoubleArrayAsIterable usingTolerance(double tolerance) {
        return new DoubleArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static double checkedToDouble(Number expected) {
        Preconditions.checkNotNull(expected);
        Preconditions.checkArgument(expected instanceof Double || expected instanceof Float || expected instanceof Integer || expected instanceof Long, "Expected value in assertion using exact double equality was of unsupported type %s (it may not have an exact double representation)", expected.getClass());
        if (expected instanceof Long) {
            Preconditions.checkArgument(Math.abs((Long)expected) <= 0x20000000000000L, "Expected value %s in assertion using exact double equality was a long with an absolute value greater than 2^52 which has no exact double representation", (Object)expected);
        }
        return expected.doubleValue();
    }

    public DoubleArrayAsIterable usingExactEquality() {
        return new DoubleArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.checkNoNeedToDisplayBothValues("asList()", new Object[0]).about(this.iterablesWithCustomDoubleToString()).that(Doubles.asList((double[])this.actual()));
    }

    private Subject.Factory<IterableSubject, Iterable<?>> iterablesWithCustomDoubleToString() {
        return new Subject.Factory<IterableSubject, Iterable<?>>(){

            @Override
            public IterableSubject createSubject(FailureMetadata metadata, Iterable<?> actual) {
                return new IterableSubjectWithInheritedToString(metadata, actual);
            }
        };
    }

    private final class IterableSubjectWithInheritedToString
    extends IterableSubject {
        IterableSubjectWithInheritedToString(FailureMetadata metadata, Iterable<?> actual) {
            super(metadata, actual);
        }

        @Override
        protected String actualCustomStringRepresentation() {
            return PrimitiveDoubleArraySubject.this.actualCustomStringRepresentationForPackageMembersToCall();
        }
    }

    public static final class DoubleArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Double, Number> {
        DoubleArrayAsIterable(Correspondence<? super Double, Number> correspondence, IterableSubject subject) {
            super(subject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAllOf(double[] expected) {
            return this.containsAllIn(Doubles.asList(expected));
        }

        public void containsAnyOf(double[] expected) {
            this.containsAnyIn(Doubles.asList(expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(double[] expected) {
            return this.containsExactlyElementsIn(Doubles.asList(expected));
        }

        public void containsNoneOf(double[] excluded) {
            this.containsNoneIn(Doubles.asList(excluded));
        }
    }

    public static abstract class TolerantPrimitiveDoubleArrayComparison {
        private TolerantPrimitiveDoubleArrayComparison() {
        }

        public void of(double ... expected) {
            this.ofElementsIn(Doubles.asList(expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@NullableDecl Object o) {
            throw new UnsupportedOperationException("If you meant to compare double arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

