/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BackupUtils;
import com.android.tradefed.util.RunUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BackupUtilsTest {
    private static final int BACKUP_SERVICE_INIT_TIMEOUT_SECS = 1;
    private static final int TEST_USER_ID = 10;
    private boolean mIsDumpsysCommandCalled;
    private boolean mIsEnableCommandCalled;
    private boolean mIsActivateCommandCalled;

    @Before
    public void setUp() {
        this.mIsDumpsysCommandCalled = false;
        this.mIsEnableCommandCalled = false;
    }

    @Test
    public void testEnableBackup_whenEnableTrueAndEnabled_returnsTrue() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently enabled";
                } else if (command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertTrue((boolean)backupUtils.enableBackup(true));
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenEnableTrueAndDisabled_returnsFalse() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently disabled";
                } else if (command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertFalse((boolean)backupUtils.enableBackup(true));
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenEnableFalseAndEnabled_returnsTrue() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently enabled";
                } else if (command.equals("bmgr enable false")) {
                    output = "Backup Manager now disabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertTrue((boolean)backupUtils.enableBackup(false));
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenEnableFalseAndDisabled_returnsFalse() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently disabled";
                } else if (command.equals("bmgr enable false")) {
                    output = "Backup Manager now disabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertFalse((boolean)backupUtils.enableBackup(false));
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenEnableTrueAndEnabledAndCommandsReturnMultipleLines() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently enabled\n...";
                } else if (command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled\n...";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertTrue((boolean)backupUtils.enableBackup(true));
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenQueryCommandThrows_propagatesException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    throw new IOException(String.format("enableBackup: Failed to run command: %s", command));
                }
                if (command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.enableBackup(true);
        }
        catch (IOException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertFalse((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenSetCommandThrows_propagatesException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager currently enabled";
                } else if (command.equals("bmgr enable true")) {
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                    throw new IOException(String.format("enableBackup: Failed to run command: %s", command));
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.enableBackup(true);
        }
        catch (IOException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertTrue((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenQueryCommandReturnsInvalidString_throwsException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("bmgr enabled")) {
                    output = "Backup Manager ???";
                } else if (command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.enableBackup(true);
        }
        catch (RuntimeException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertFalse((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testEnableBackup_whenQueryCommandReturnsEmptyString_throwsException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (!command.equals("bmgr enabled") && command.equals("bmgr enable true")) {
                    output = "Backup Manager now enabled";
                    BackupUtilsTest.this.mIsEnableCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.enableBackup(true);
        }
        catch (NullPointerException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertFalse((boolean)this.mIsEnableCommandCalled);
    }

    @Test
    public void testWaitForBackupInitialization_whenEnabled() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup")) {
                    output = "Backup Manager is enabled / provisioned / not pending init";
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        backupUtils.waitForBackupInitialization();
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    @Test
    public void testWaitForBackupInitialization_whenDisabled() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup")) {
                    output = "Backup Manager is disabled / provisioned / not pending init";
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        backupUtils.waitForBackupInitialization();
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    @Test
    public void testWaitUntilBackupServiceIsRunning_whenRunning_doesntThrow() throws Exception {
        BackupUtils backupUtils = this.constructDumpsysForBackupUsers(10);
        try {
            backupUtils.waitUntilBackupServiceIsRunning(10, 1L);
        }
        catch (AssertionError e) {
            Assert.fail((String)"BackupUtils#waitUntilBackupServiceIsRunning threw an exception");
        }
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    @Test
    public void testWaitUntilBackupServiceIsRunning_whenNotRunning_throws() throws Exception {
        BackupUtils backupUtils = this.constructDumpsysForBackupUsers(11);
        boolean wasExceptionThrown = false;
        try {
            backupUtils.waitUntilBackupServiceIsRunning(10, 1L);
        }
        catch (AssertionError e) {
            wasExceptionThrown = true;
        }
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
        Assert.assertTrue((boolean)wasExceptionThrown);
    }

    private BackupUtils constructDumpsysForBackupUsers(final int runningUserId) {
        return new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup users")) {
                    output = "Backup Manager is running for users: " + runningUserId;
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
    }

    @Test
    public void testWaitForBackupInitialization_whenEnabledAndCommandReturnsMultipleLines() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup")) {
                    output = "Backup Manager is enabled / provisioned / not pending init\n...";
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        backupUtils.waitForBackupInitialization();
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    @Test
    public void testWaitForBackupInitialization_whenCommandThrows_propagatesException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup")) {
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                    throw new IOException(String.format("waitForBackupInitialization: Failed to run command: %s", command));
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.waitForBackupInitialization();
        }
        catch (IOException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitForBackupInitialization_whenCommandReturnsInvalidString() throws Exception {
        class TestRunnable
        implements Runnable {
            TestRunnable() {
            }

            @Override
            public void run() {
                try {
                    BackupUtils backupUtils = new BackupUtils(){

                        protected InputStream executeShellCommand(String command) throws IOException {
                            String output = "";
                            if (command.equals("dumpsys backup")) {
                                output = "Backup Manager ???";
                                BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                            }
                            return new ByteArrayInputStream(output.getBytes("UTF-8"));
                        }
                    };
                    backupUtils.waitForBackupInitialization();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TestRunnable testRunnable = new TestRunnable();
        Thread testThread = new Thread(testRunnable);
        try {
            testThread.start();
            RunUtil.getDefault().sleep(100L);
            Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
            Assert.assertTrue((boolean)testThread.isAlive());
        }
        catch (Exception exception) {
        }
        finally {
            testThread.interrupt();
        }
    }

    @Test
    public void testWaitForBackupInitialization_whenCommandReturnsEmptyString_throwsException() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals("dumpsys backup")) {
                    BackupUtilsTest.this.mIsDumpsysCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        boolean isExceptionHappened = false;
        try {
            backupUtils.waitForBackupInitialization();
        }
        catch (NullPointerException e) {
            isExceptionHappened = true;
        }
        Assert.assertTrue((boolean)isExceptionHappened);
        Assert.assertTrue((boolean)this.mIsDumpsysCommandCalled);
    }

    @Test
    public void testActivateBackup_whenEnableTrueAndEnabled_returnsTrue() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals(BackupUtilsTest.this.getBmgrCommand("activated", 10))) {
                    output = "Backup Manager currently activated";
                } else if (command.equals(BackupUtilsTest.this.getBmgrCommand("activate true", 10))) {
                    output = "Backup Manager now activated";
                    BackupUtilsTest.this.mIsActivateCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertTrue((boolean)backupUtils.activateBackupForUser(true, 10));
        Assert.assertTrue((boolean)this.mIsActivateCommandCalled);
    }

    @Test
    public void testActivateBackup_whenEnableTrueAndDisabled_returnsFalse() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals(BackupUtilsTest.this.getBmgrCommand("activated", 10))) {
                    output = "Backup Manager currently deactivated";
                } else if (command.equals(BackupUtilsTest.this.getBmgrCommand("activate true", 10))) {
                    output = "Backup Manager now activated";
                    BackupUtilsTest.this.mIsActivateCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertFalse((boolean)backupUtils.activateBackupForUser(true, 10));
        Assert.assertTrue((boolean)this.mIsActivateCommandCalled);
    }

    @Test
    public void testActivateBackup_whenEnableFalseAndEnabled_returnsTrue() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals(BackupUtilsTest.this.getBmgrCommand("activated", 10))) {
                    output = "Backup Manager currently activated";
                } else if (command.equals(BackupUtilsTest.this.getBmgrCommand("activate false", 10))) {
                    output = "Backup Manager now deactivated";
                    BackupUtilsTest.this.mIsActivateCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertTrue((boolean)backupUtils.activateBackupForUser(false, 10));
        Assert.assertTrue((boolean)this.mIsActivateCommandCalled);
    }

    @Test
    public void testActivateBackup_whenEnableFalseAndDisabled_returnsFalse() throws Exception {
        BackupUtils backupUtils = new BackupUtils(){

            protected InputStream executeShellCommand(String command) throws IOException {
                String output = "";
                if (command.equals(BackupUtilsTest.this.getBmgrCommand("activated", 10))) {
                    output = "Backup Manager currently deactivated";
                } else if (command.equals(BackupUtilsTest.this.getBmgrCommand("activate false", 10))) {
                    output = "Backup Manager now deactivated";
                    BackupUtilsTest.this.mIsActivateCommandCalled = true;
                }
                return new ByteArrayInputStream(output.getBytes("UTF-8"));
            }
        };
        Assert.assertFalse((boolean)backupUtils.activateBackupForUser(false, 10));
        Assert.assertTrue((boolean)this.mIsActivateCommandCalled);
    }

    private String getBmgrCommand(String command, int userId) {
        return "bmgr --user " + userId + " " + command;
    }
}

