/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BusinessLogic;
import com.android.compatibility.common.util.BusinessLogicFactory;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BusinessLogicTest {
    private static final String CORRECT_LOGIC = "{\n  \"name\": \"businessLogic/suites/gts\",\n  \"businessLogicRulesLists\": [\n    {\n      \"testName\": \"testCaseName1\",\n      \"description\": \"first test\",\n      \"businessLogicRules\": [\n        {\n          \"ruleConditions\": [\n            {\n              \"methodName\": \"conditionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\"\n              ]\n            }\n          ],\n          \"ruleActions\": [\n            {\n              \"methodName\": \"actionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\",\n                \"arg2\"\n              ]\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"testName\": \"testCaseName2\",\n      \"businessLogicRules\": [\n        {\n          \"ruleConditions\": [\n            {\n              \"methodName\": \"conditionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\"\n              ]\n            }\n          ],\n          \"ruleActions\": [\n            {\n              \"methodName\": \"actionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\",\n                \"arg2\"\n              ]\n            }\n          ]\n        },\n        {\n          \"ruleConditions\": [\n            {\n              \"methodName\": \"conditionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\"\n              ]\n            },\n            {\n              \"methodName\": \"!conditionMethodName2\",\n              \"methodArgs\": [\n                \"arg2\"\n              ]\n            }\n          ],\n          \"ruleActions\": [\n            {\n              \"methodName\": \"actionMethodName1\",\n              \"methodArgs\": [\n                \"arg1\",\n                \"arg2\"\n              ]\n            },\n            {\n              \"methodName\": \"actionMethodName2\"\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"testName\": \"testCaseName3\"\n    }\n  ]\n}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectLogic() throws Exception {
        File file = BusinessLogicTest.createFileFromStr(CORRECT_LOGIC);
        try {
            BusinessLogic bl = BusinessLogicFactory.createFromFile((File)file);
            Assert.assertEquals((String)"Wrong number of business logic rule lists", (int)3, (int)bl.mRules.size());
            String description = ((BusinessLogic.BusinessLogicRulesList)((List)bl.mRules.get("testCaseName1")).get(0)).getDescription();
            Assert.assertEquals((String)"Wrong or missing rule list description", (String)"first test", (String)description);
            List rulesList1 = ((BusinessLogic.BusinessLogicRulesList)((List)bl.mRules.get("testCaseName1")).get(0)).getRules();
            Assert.assertEquals((String)"Wrong number of rules in first rule list", (int)1, (int)rulesList1.size());
            BusinessLogic.BusinessLogicRule rule1 = (BusinessLogic.BusinessLogicRule)rulesList1.get(0);
            List rule1Conditions = rule1.mConditions;
            Assert.assertEquals((String)"Wrong number of conditions", (int)1, (int)rule1Conditions.size());
            BusinessLogic.BusinessLogicRuleCondition rule1Condition = (BusinessLogic.BusinessLogicRuleCondition)rule1Conditions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule condition", (String)"conditionMethodName1", (String)rule1Condition.mMethodName);
            Assert.assertFalse((String)"Wrong negation value for business logic rule condition", (boolean)rule1Condition.mNegated);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule condition", (int)1, (int)rule1Condition.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule condition", (String)"arg1", (String)((String)rule1Condition.mMethodArgs.get(0)));
            List rule1Actions = rule1.mActions;
            Assert.assertEquals((String)"Wrong number of actions", (int)1, (int)rule1Actions.size());
            BusinessLogic.BusinessLogicRuleAction rule1Action = (BusinessLogic.BusinessLogicRuleAction)rule1Actions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule action", (String)"actionMethodName1", (String)rule1Action.mMethodName);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule action", (int)2, (int)rule1Action.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg1", (String)((String)rule1Action.mMethodArgs.get(0)));
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg2", (String)((String)rule1Action.mMethodArgs.get(1)));
            List rulesList2 = ((BusinessLogic.BusinessLogicRulesList)((List)bl.mRules.get("testCaseName2")).get(0)).getRules();
            Assert.assertEquals((String)"Wrong number of rules in second rule list", (int)2, (int)rulesList2.size());
            BusinessLogic.BusinessLogicRule rule2 = (BusinessLogic.BusinessLogicRule)rulesList2.get(0);
            List rule2Conditions = rule2.mConditions;
            Assert.assertEquals((String)"Wrong number of conditions", (int)1, (int)rule2Conditions.size());
            BusinessLogic.BusinessLogicRuleCondition rule2Condition = (BusinessLogic.BusinessLogicRuleCondition)rule2Conditions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule condition", (String)"conditionMethodName1", (String)rule2Condition.mMethodName);
            Assert.assertFalse((String)"Wrong negation value for business logic rule condition", (boolean)rule2Condition.mNegated);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule condition", (int)1, (int)rule2Condition.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule condition", (String)"arg1", (String)((String)rule2Condition.mMethodArgs.get(0)));
            List rule2Actions = rule2.mActions;
            Assert.assertEquals((String)"Wrong number of actions", (int)1, (int)rule2Actions.size());
            BusinessLogic.BusinessLogicRuleAction rule2Action = (BusinessLogic.BusinessLogicRuleAction)rule2Actions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule action", (String)"actionMethodName1", (String)rule2Action.mMethodName);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule action", (int)2, (int)rule2Action.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg1", (String)((String)rule2Action.mMethodArgs.get(0)));
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg2", (String)((String)rule2Action.mMethodArgs.get(1)));
            BusinessLogic.BusinessLogicRule rule3 = (BusinessLogic.BusinessLogicRule)rulesList2.get(1);
            List rule3Conditions = rule3.mConditions;
            Assert.assertEquals((String)"Wrong number of conditions", (int)2, (int)rule3Conditions.size());
            BusinessLogic.BusinessLogicRuleCondition rule3Condition1 = (BusinessLogic.BusinessLogicRuleCondition)rule3Conditions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule condition", (String)"conditionMethodName1", (String)rule3Condition1.mMethodName);
            Assert.assertFalse((String)"Wrong negation value for business logic rule condition", (boolean)rule3Condition1.mNegated);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule condition", (int)1, (int)rule3Condition1.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule condition", (String)"arg1", (String)((String)rule3Condition1.mMethodArgs.get(0)));
            BusinessLogic.BusinessLogicRuleCondition rule3Condition2 = (BusinessLogic.BusinessLogicRuleCondition)rule3Conditions.get(1);
            Assert.assertEquals((String)"Wrong method name for business logic rule condition", (String)"conditionMethodName2", (String)rule3Condition2.mMethodName);
            Assert.assertTrue((String)"Wrong negation value for business logic rule condition", (boolean)rule3Condition2.mNegated);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule condition", (int)1, (int)rule3Condition2.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule condition", (String)"arg2", (String)((String)rule3Condition2.mMethodArgs.get(0)));
            List rule3Actions = rule3.mActions;
            Assert.assertEquals((String)"Wrong number of actions", (int)2, (int)rule3Actions.size());
            BusinessLogic.BusinessLogicRuleAction rule3Action1 = (BusinessLogic.BusinessLogicRuleAction)rule3Actions.get(0);
            Assert.assertEquals((String)"Wrong method name for business logic rule action", (String)"actionMethodName1", (String)rule3Action1.mMethodName);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule action", (int)2, (int)rule3Action1.mMethodArgs.size());
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg1", (String)((String)rule3Action1.mMethodArgs.get(0)));
            Assert.assertEquals((String)"Wrong arg for business logic rule action", (String)"arg2", (String)((String)rule3Action1.mMethodArgs.get(1)));
            BusinessLogic.BusinessLogicRuleAction rule3Action2 = (BusinessLogic.BusinessLogicRuleAction)rule3Actions.get(1);
            Assert.assertEquals((String)"Wrong method name for business logic rule action", (String)"actionMethodName2", (String)rule3Action2.mMethodName);
            Assert.assertEquals((String)"Wrong arg string count for business logic rule action", (int)0, (int)rule3Action2.mMethodArgs.size());
            List rulesList3 = ((BusinessLogic.BusinessLogicRulesList)((List)bl.mRules.get("testCaseName3")).get(0)).getRules();
            Assert.assertEquals((String)"Wrong number of rules in third rule list", (int)0, (int)rulesList3.size());
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testLogicWithWrongNodeName() throws Exception {
        File file = BusinessLogicTest.createFileFromStr(CORRECT_LOGIC.replace("testName", "testNam3"));
        try {
            BusinessLogic businessLogic = BusinessLogicFactory.createFromFile((File)file);
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
    }

    private static File createFileFromStr(String blString) throws IOException {
        File file = File.createTempFile("test", "bl");
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(blString.getBytes());
        stream.flush();
        stream.close();
        return file;
    }
}

