/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.MetricsXmlSerializer;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class MetricsXmlSerializerTest
extends TestCase {
    private static final double[] VALUES = new double[]{1.0, 11.0, 21.0, 1211.0, 111221.0};
    private static final String HEADER = "<?xml version='1.0' encoding='utf-8' standalone='yes' ?>";
    private static final String EXPECTED_XML = "<?xml version='1.0' encoding='utf-8' standalone='yes' ?><Summary message=\"Sample\" scoreType=\"higher_better\" unit=\"byte\">1.0</Summary>";
    private LocalReportLog mLocalReportLog;
    private MetricsXmlSerializer mMetricsXmlSerializer;
    private ByteArrayOutputStream mByteArrayOutputStream;
    private XmlSerializer xmlSerializer;

    public void setUp() throws Exception {
        this.mLocalReportLog = new LocalReportLog();
        this.mByteArrayOutputStream = new ByteArrayOutputStream();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(null, null);
        this.xmlSerializer = factory.newSerializer();
        this.xmlSerializer.setOutput((OutputStream)this.mByteArrayOutputStream, "utf-8");
        this.mMetricsXmlSerializer = new MetricsXmlSerializer(this.xmlSerializer);
    }

    public void testSerialize_null() throws IOException {
        this.xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
        this.mMetricsXmlSerializer.serialize(null);
        this.xmlSerializer.endDocument();
        MetricsXmlSerializerTest.assertEquals((int)HEADER.length(), (int)this.mByteArrayOutputStream.toByteArray().length);
    }

    public void testSerialize_noData() throws IOException {
        this.xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
        this.mMetricsXmlSerializer.serialize((ReportLog)this.mLocalReportLog);
        this.xmlSerializer.endDocument();
        MetricsXmlSerializerTest.assertEquals((int)HEADER.length(), (int)this.mByteArrayOutputStream.toByteArray().length);
    }

    public void testSerialize() throws IOException {
        this.mLocalReportLog.setSummary("Sample", 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        this.mLocalReportLog.addValues("Details", VALUES, ResultType.NEUTRAL, ResultUnit.FPS);
        this.xmlSerializer.startDocument("utf-8", Boolean.valueOf(true));
        this.mMetricsXmlSerializer.serialize((ReportLog)this.mLocalReportLog);
        this.xmlSerializer.endDocument();
        MetricsXmlSerializerTest.assertEquals((String)EXPECTED_XML, (String)this.mByteArrayOutputStream.toString("utf-8"));
    }

    static class LocalReportLog
    extends ReportLog {
        LocalReportLog() {
        }
    }
}

