/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import java.util.Arrays;
import junit.framework.TestCase;

public class ReportLogTest
extends TestCase {
    private static final String SOURCE = "Source";
    private static final String MESSAGE = "Message";
    private static final double[] VALUES = new double[]{0.1, 124.0, 4736.0, 835.683, 98.0, 395.0};
    private static final String HEADER_XML = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>";
    private static final String SUMMARY_XML = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>";
    private static final String FULL_XML = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>";
    private ReportLog mReportLog;

    protected void setUp() throws Exception {
        this.mReportLog = new ReportLog();
    }

    public void testSerialize_null() throws Exception {
        try {
            ReportLog.serialize(null);
            ReportLogTest.fail((String)"Expected IllegalArgumentException when serializing an empty report");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSerialize_noData() throws Exception {
        ReportLog.serialize((ReportLog)this.mReportLog);
    }

    public void testSerialize_summaryOnly() throws Exception {
        this.mReportLog.setSummary("Sample", 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertEquals((String)String.format("<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>", "testSerialize_summaryOnly:66"), (String)ReportLog.serialize((ReportLog)this.mReportLog));
    }

    public void testSerialize_detailOnly() throws Exception {
        this.mReportLog.addValues("Details", VALUES, ResultType.NEUTRAL, ResultUnit.FPS);
        ReportLogTest.assertEquals((String)HEADER_XML, (String)ReportLog.serialize((ReportLog)this.mReportLog));
    }

    public void testSerialize_full() throws Exception {
        this.mReportLog.setSummary("Sample", 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        this.mReportLog.addValues("Details", VALUES, ResultType.NEUTRAL, ResultUnit.FPS);
        ReportLogTest.assertEquals((String)String.format("<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>", "testSerialize_full:77"), (String)ReportLog.serialize((ReportLog)this.mReportLog));
    }

    public void testParse_null() throws Exception {
        try {
            ReportLog.parse((String)null);
            ReportLogTest.fail((String)"Expected IllegalArgumentException when passing a null report");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_noData() throws Exception {
        ReportLog report = ReportLog.parse((String)HEADER_XML);
        ReportLogTest.assertNull((Object)report.getSummary());
    }

    public void testParse_summaryOnly() throws Exception {
        ReportLog report = ReportLog.parse((String)String.format("<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>", "testParse_summaryOnly:125"));
        ReportLogTest.assertNotNull((Object)report);
        ReportLogTest.assertEquals((String)"Sample", (String)report.getSummary().getMessage());
    }

    public void testParse_full() throws Exception {
        ReportLog report = ReportLog.parse((String)String.format("<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\r\n<Summary>\r\n  <Metric source=\"com.android.compatibility.common.util.ReportLogTest#%s\" message=\"Sample\" score_type=\"higher_better\" score_unit=\"byte\">\r\n    <Value>1.0</Value>\r\n  </Metric>\r\n</Summary>", "testParse_full:140"));
        ReportLogTest.assertNotNull((Object)report);
        ReportLogTest.assertEquals((String)"Sample", (String)report.getSummary().getMessage());
    }

    public void testLimits_source() throws Exception {
        ReportLog.Metric metric = new ReportLog.Metric(SOURCE, MESSAGE, 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertEquals((String)"Expected message to be ok", (String)SOURCE, (String)metric.getSource());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 40; ++i) {
            sb.append(SOURCE);
        }
        String source = sb.toString();
        metric = new ReportLog.Metric(source, MESSAGE, 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertEquals((String)"Expected source to be trimmed", (String)source.substring(source.length() - 200), (String)metric.getSource());
    }

    public void testLimits_message() throws Exception {
        ReportLog.Metric metric = new ReportLog.Metric(SOURCE, MESSAGE, 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertEquals((String)"Expected message to be ok", (String)MESSAGE, (String)metric.getMessage());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 40; ++i) {
            sb.append(MESSAGE);
        }
        String message = sb.toString();
        metric = new ReportLog.Metric(SOURCE, message, 1.0, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertEquals((String)"Expected message to be trimmed", (String)message.substring(0, 200), (String)metric.getMessage());
    }

    public void testLimits_values() throws Exception {
        ReportLog.Metric metric = new ReportLog.Metric(SOURCE, MESSAGE, VALUES, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertTrue((String)"Expected values to be ok", (boolean)Arrays.equals(VALUES, metric.getValues()));
        double[] values = new double[1001];
        for (int i = 0; i < values.length; ++i) {
            values[i] = i;
        }
        metric = new ReportLog.Metric(SOURCE, MESSAGE, values, ResultType.HIGHER_BETTER, ResultUnit.BYTE);
        ReportLogTest.assertTrue((String)"Expected values to be trimmed", (boolean)Arrays.equals(Arrays.copyOf(values, 1000), metric.getValues()));
    }
}

