/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.Stat;
import junit.framework.TestCase;

public class StatTest
extends TestCase {
    public void testGet95PercentileValue() {
        int i;
        double[] values = new double[100];
        for (i = 0; i < 100; ++i) {
            values[i] = i;
        }
        StatTest.assertEquals((int)95, (int)((int)Stat.get95PercentileValue((double[])values)));
        values = new double[1000];
        for (i = 0; i < 1000; ++i) {
            values[i] = i;
        }
        StatTest.assertEquals((int)950, (int)((int)Stat.get95PercentileValue((double[])values)));
        values = new double[100];
        for (i = 0; i < 100; ++i) {
            values[i] = i * i;
        }
        StatTest.assertEquals((int)9025, (int)((int)Stat.get95PercentileValue((double[])values)));
    }

    public void testGetAverage() {
        double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double average = Stat.getAverage((double[])values);
        StatTest.assertEquals((double)2.0, (double)average, (double)1.0E-5);
        values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        average = Stat.getAverage((double[])values);
        StatTest.assertEquals((double)3.0, (double)average, (double)1.0E-5);
        values = new double[]{0.0, 1.0, 4.0, 9.0, 16.0};
        average = Stat.getAverage((double[])values);
        StatTest.assertEquals((double)6.0, (double)average, (double)1.0E-5);
    }

    public void testGetStandardDeviation() {
        double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
        double stddev = Stat.getStat((double[])values).mStddev;
        StatTest.assertEquals((double)Math.sqrt(2.5), (double)stddev, (double)1.0E-5);
        values = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        stddev = Stat.getStat((double[])values).mStddev;
        StatTest.assertEquals((double)Math.sqrt(2.5), (double)stddev, (double)1.0E-5);
        values = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        stddev = Stat.getStat((double[])values).mStddev;
        StatTest.assertEquals((double)Math.sqrt(10.0), (double)stddev, (double)1.0E-5);
    }
}

