/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryUsageItem
implements IItem {
    public static final String BATTERY_USAGE = "BATTERY_USAGE";
    public static final String BATTERY_CAPACITY = "BATTERY_CAPACITY";
    private Collection<BatteryUsageInfoItem> mBatteryUsage = new LinkedList<BatteryUsageInfoItem>();
    private int mBatteryCapacity = 0;

    public void addBatteryUsage(String name, double usage) {
        this.mBatteryUsage.add(new BatteryUsageInfoItem(name, usage));
    }

    public int getBatteryCapacity() {
        return this.mBatteryCapacity;
    }

    public List<BatteryUsageInfoItem> getBatteryUsage() {
        return (List)this.mBatteryUsage;
    }

    public void setBatteryCapacity(int capacity) {
        this.mBatteryCapacity = capacity;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Wakelock items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        if (this.mBatteryUsage != null) {
            try {
                object.put(BATTERY_CAPACITY, this.mBatteryCapacity);
                JSONArray usageInfo = new JSONArray();
                for (BatteryUsageInfoItem usage : this.mBatteryUsage) {
                    usageInfo.put((Object)usage.toJson());
                }
                object.put(BATTERY_USAGE, (Object)usageInfo);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object;
    }

    public static class BatteryUsageInfoItem
    extends GenericItem {
        public static final String NAME = "NAME";
        public static final String USAGE = "USAGE";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("NAME", "USAGE"));

        public BatteryUsageInfoItem(String name, double usage) {
            super(ATTRIBUTES);
            this.setAttribute(NAME, name);
            this.setAttribute(USAGE, usage);
        }

        public String getName() {
            return (String)this.getAttribute(NAME);
        }

        public double getUsage() {
            return (Double)this.getAttribute(USAGE);
        }
    }
}

