/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcrankItem
implements IItem {
    public static final String TYPE = "PROCRANK";
    public static final String LINES = "LINES";
    public static final String PID = "PID";
    public static final String PROCESS_NAME = "PROCESS_NAME";
    public static final String VSS = "VSS";
    public static final String RSS = "RSS";
    public static final String PSS = "PSS";
    public static final String USS = "USS";
    public static final String TEXT = "TEXT";
    private String mText = null;
    private Map<Integer, ProcrankValue> mProcrankLines = new HashMap<Integer, ProcrankValue>();

    public void addProcrankLine(int pid, String processName, int vss, int rss, int pss, int uss) {
        this.mProcrankLines.put(pid, new ProcrankValue(processName, vss, rss, pss, uss));
    }

    public Set<Integer> getPids() {
        return this.mProcrankLines.keySet();
    }

    public String getProcessName(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mProcessName;
    }

    public Integer getVss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mVss;
    }

    public Integer getRss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mRss;
    }

    public Integer getPss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mPss;
    }

    public Integer getUss(int pid) {
        if (!this.mProcrankLines.containsKey(pid)) {
            return null;
        }
        return this.mProcrankLines.get((Object)Integer.valueOf((int)pid)).mUss;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Procrank items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        JSONArray lines = new JSONArray();
        try {
            for (Map.Entry<Integer, ProcrankValue> entry : this.mProcrankLines.entrySet()) {
                ProcrankValue procrankValue = entry.getValue();
                JSONObject line = new JSONObject();
                line.put(PID, (Object)entry.getKey());
                line.put(PROCESS_NAME, (Object)procrankValue.mProcessName);
                line.put(VSS, procrankValue.mVss);
                line.put(RSS, procrankValue.mRss);
                line.put(PSS, procrankValue.mPss);
                line.put(USS, procrankValue.mUss);
                lines.put((Object)line);
            }
            object.put(LINES, (Object)lines);
            object.put(TEXT, (Object)this.getText());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    private class ProcrankValue {
        public String mProcessName;
        public int mVss;
        public int mRss;
        public int mPss;
        public int mUss;

        public ProcrankValue(String processName, int vss, int rss, int pss, int uss) {
            this.mProcessName = processName;
            this.mVss = vss;
            this.mRss = rss;
            this.mPss = pss;
            this.mUss = uss;
        }
    }
}

