/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.BatteryDischargeItem;
import com.android.loganalysis.item.BatteryStatsSummaryInfoItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatteryStatsSummaryInfoParser
implements IParser {
    private static final Pattern RESET_TIME_PATTERN = Pattern.compile("^\\s*\\d\\s*\\(\\d+\\)\\s*RESET:TIME:\\s*(\\d+)-(\\d+)-(\\d+)-(\\d+)-(\\d+)-(\\d+)$");
    private static final Pattern BATTERY_DISCHARGE_PATTERN = Pattern.compile("^\\s*\\+(?:(\\d+)d)?(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?(?:(\\d+)ms)? \\(\\d+\\) (\\d+) \\w+ .*");
    private BatteryDischargeItem mBatteryDischarge = new BatteryDischargeItem();
    private BatteryStatsSummaryInfoItem mItem = new BatteryStatsSummaryInfoItem();
    private long mBatteryDischargeRateAvg = 0L;
    private int mBatteryDischargeSamples = 0;
    private Calendar mResetTime;
    private static final int BATTERY_GROUP_LIMIT = 10;

    @Override
    public BatteryStatsSummaryInfoItem parse(List<String> lines) {
        Matcher resetTimeMatcher = null;
        Matcher dischargeMatcher = null;
        long previousDischargeElapsedTime = 0L;
        int previousBatteryLevel = 0;
        boolean batteryDischargedFully = false;
        for (String line : lines) {
            resetTimeMatcher = RESET_TIME_PATTERN.matcher(line);
            dischargeMatcher = BATTERY_DISCHARGE_PATTERN.matcher(line);
            if (resetTimeMatcher.matches()) {
                this.mResetTime = new GregorianCalendar();
                int year = Integer.parseInt(resetTimeMatcher.group(1));
                int month = Integer.parseInt(resetTimeMatcher.group(2));
                int day = Integer.parseInt(resetTimeMatcher.group(3));
                int hour = Integer.parseInt(resetTimeMatcher.group(4));
                int minute = Integer.parseInt(resetTimeMatcher.group(5));
                int second = Integer.parseInt(resetTimeMatcher.group(6));
                this.mResetTime.set(year, month - 1, day, hour, minute, second);
                continue;
            }
            if (!dischargeMatcher.matches()) continue;
            int days = NumberFormattingUtil.parseIntOrZero(dischargeMatcher.group(1));
            int hours = NumberFormattingUtil.parseIntOrZero(dischargeMatcher.group(2));
            int mins = NumberFormattingUtil.parseIntOrZero(dischargeMatcher.group(3));
            int secs = NumberFormattingUtil.parseIntOrZero(dischargeMatcher.group(4));
            int msecs = NumberFormattingUtil.parseIntOrZero(dischargeMatcher.group(5));
            int batteryLevel = Integer.parseInt(dischargeMatcher.group(6));
            if (batteryLevel == 0) {
                batteryDischargedFully = true;
                continue;
            }
            if (previousBatteryLevel == 0) {
                previousBatteryLevel = batteryLevel;
                continue;
            }
            if (batteryDischargedFully || previousBatteryLevel == batteryLevel) continue;
            long elapsedTime = NumberFormattingUtil.getMs(days, hours, mins, secs, msecs);
            this.mBatteryDischargeRateAvg += elapsedTime - previousDischargeElapsedTime;
            ++this.mBatteryDischargeSamples;
            this.mBatteryDischarge.addBatteryDischargeInfo(this.getDischargeClockTime(days, hours, mins, secs), elapsedTime - previousDischargeElapsedTime, batteryLevel);
            previousDischargeElapsedTime = elapsedTime;
            previousBatteryLevel = batteryLevel;
        }
        this.mItem.setBatteryDischargeRate(this.getAverageDischargeRate());
        this.mItem.setPeakDischargeTime(this.getPeakDischargeTime());
        return this.mItem;
    }

    private Calendar getDischargeClockTime(int days, int hours, int mins, int secs) {
        GregorianCalendar dischargeClockTime = new GregorianCalendar();
        dischargeClockTime.setTime(this.mResetTime.getTime());
        ((Calendar)dischargeClockTime).add(5, days);
        ((Calendar)dischargeClockTime).add(10, hours);
        ((Calendar)dischargeClockTime).add(12, mins);
        ((Calendar)dischargeClockTime).add(13, secs);
        return dischargeClockTime;
    }

    private String getAverageDischargeRate() {
        if (this.mBatteryDischargeSamples == 0) {
            return "The battery did not discharge";
        }
        long minsPerLevel = this.mBatteryDischargeRateAvg / (long)(this.mBatteryDischargeSamples * 60 * 1000);
        return String.format("The battery dropped a level %d mins on average", minsPerLevel);
    }

    private String getPeakDischargeTime() {
        int peakDischargeStartBatteryLevel = 0;
        int peakDischargeStopBatteryLevel = 0;
        long minDischargeDuration = 0L;
        Calendar peakDischargeStartTime = null;
        Calendar peakDischargeStopTime = null;
        LinkedList<BatteryDischargeItem.BatteryDischargeInfoItem> batteryDischargeWindow = new LinkedList<BatteryDischargeItem.BatteryDischargeInfoItem>();
        long sumDischargeDuration = 0L;
        for (BatteryDischargeItem.BatteryDischargeInfoItem dischargeSteps : this.mBatteryDischarge.getDischargeStepsInfo()) {
            batteryDischargeWindow.add(dischargeSteps);
            sumDischargeDuration += dischargeSteps.getElapsedTime();
            if (batteryDischargeWindow.size() < 10) continue;
            long averageDischargeDuration = sumDischargeDuration / 10L;
            BatteryDischargeItem.BatteryDischargeInfoItem startNode = (BatteryDischargeItem.BatteryDischargeInfoItem)batteryDischargeWindow.remove();
            sumDischargeDuration -= startNode.getElapsedTime();
            if (minDischargeDuration != 0L && averageDischargeDuration >= minDischargeDuration) continue;
            minDischargeDuration = averageDischargeDuration;
            peakDischargeStartBatteryLevel = startNode.getBatteryLevel();
            peakDischargeStopBatteryLevel = dischargeSteps.getBatteryLevel();
            peakDischargeStartTime = startNode.getClockTime();
            peakDischargeStopTime = dischargeSteps.getClockTime();
        }
        if (peakDischargeStartTime != null && peakDischargeStopTime != null && peakDischargeStartBatteryLevel > 0 && peakDischargeStopBatteryLevel > 0) {
            return String.format("The peak discharge time was during %s to %s where battery dropped from %d to %d", peakDischargeStartTime.getTime().toString(), peakDischargeStopTime.getTime().toString(), peakDischargeStartBatteryLevel, peakDischargeStopBatteryLevel);
        }
        return "The battery did not discharge";
    }

    BatteryStatsSummaryInfoItem getItem() {
        return this.mItem;
    }
}

