/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.BatteryUsageItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatteryUsageParser
implements IParser {
    private static final Pattern Capacity = Pattern.compile("^\\s*Capacity: (\\d+), Computed drain: \\d+.*");
    private static final Pattern Usage = Pattern.compile("^\\s*(.*): (\\d+(\\.\\d*)?)");
    private BatteryUsageItem mItem = new BatteryUsageItem();

    @Override
    public BatteryUsageItem parse(List<String> lines) {
        for (String line : lines) {
            Matcher m = Capacity.matcher(line);
            if (m.matches()) {
                this.mItem.setBatteryCapacity(Integer.parseInt(m.group(1)));
                continue;
            }
            m = Usage.matcher(line);
            if (!m.matches()) continue;
            this.mItem.addBatteryUsage(m.group(1), Double.parseDouble(m.group(2)));
        }
        return this.mItem;
    }

    BatteryUsageItem getItem() {
        return this.mItem;
    }
}

