/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.ActivityServiceItem;
import com.android.loganalysis.item.AnrItem;
import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.DumpsysItem;
import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.KernelLogItem;
import com.android.loganalysis.item.LogcatItem;
import com.android.loganalysis.item.MemInfoItem;
import com.android.loganalysis.item.MiscKernelLogItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.item.ProcrankItem;
import com.android.loganalysis.item.SystemPropsItem;
import com.android.loganalysis.item.TopItem;
import com.android.loganalysis.item.TracesItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.parser.ActivityServiceParser;
import com.android.loganalysis.parser.DumpsysParser;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.parser.KernelLogParser;
import com.android.loganalysis.parser.LogcatParser;
import com.android.loganalysis.parser.MemInfoParser;
import com.android.loganalysis.parser.NoopParser;
import com.android.loganalysis.parser.ProcrankParser;
import com.android.loganalysis.parser.SystemPropsParser;
import com.android.loganalysis.parser.TopParser;
import com.android.loganalysis.parser.TracesParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BugreportParser
extends AbstractSectionParser {
    private static final String MEM_INFO_SECTION_REGEX = "------ MEMORY INFO .*";
    private static final String PROCRANK_SECTION_REGEX = "------ PROCRANK .*";
    private static final String KERNEL_LOG_SECTION_REGEX = "------ KERNEL LOG .*";
    private static final String LAST_KMSG_SECTION_REGEX = "------ LAST KMSG .*";
    private static final String TOP_SECTION_REGEX = "------ CPU INFO .*";
    private static final String SYSTEM_PROP_SECTION_REGEX = "------ SYSTEM PROPERTIES .*";
    private static final String SYSTEM_LOG_SECTION_REGEX = "------ (SYSTEM|MAIN|MAIN AND SYSTEM) LOG .*";
    private static final String ANR_TRACES_SECTION_REGEX = "------ VM TRACES AT LAST ANR .*";
    private static final String DUMPSYS_SECTION_REGEX = "------ DUMPSYS .*";
    private static final String ACTIVITY_SERVICE_SECTION_REGEX = "^------ APP SERVICES \\(dumpsys activity service all\\) ------$";
    private static final String NOOP_SECTION_REGEX = "------ .* ------";
    private static final String BOOTREASON_PROP = "ro.boot.bootreason";
    private static final String BOOTREASON_KERNEL = "androidboot.bootreason";
    private static final Pattern DATE = Pattern.compile("^== dumpstate: (\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})$");
    private static final Pattern COMMAND_LINE = Pattern.compile("Command line: (.*)");
    private IParser mBugreportParser = new IParser(){

        @Override
        public BugreportItem parse(List<String> lines) {
            BugreportItem bugreport = null;
            for (String line : lines) {
                String[] args;
                String argString;
                Matcher m;
                if (bugreport == null && !"".equals(line.trim())) {
                    bugreport = new BugreportItem();
                }
                if ((m = DATE.matcher(line)).matches()) {
                    bugreport.setTime(BugreportParser.parseTime(m.group(1)));
                }
                if (!(m = COMMAND_LINE.matcher(line)).matches() || (argString = m.group(1).trim()).isEmpty()) continue;
                for (String arg : args = argString.split("\\s+")) {
                    String[] keyValue = arg.split("=", 2);
                    if (keyValue.length == 2) {
                        BugreportParser.this.mCommandLine.put(keyValue[0], keyValue[1]);
                        continue;
                    }
                    BugreportParser.this.mCommandLine.put(keyValue[0], null);
                }
            }
            return bugreport;
        }
    };
    private MemInfoParser mMemInfoParser = new MemInfoParser();
    private ProcrankParser mProcrankParser = new ProcrankParser();
    private TopParser mTopParser = new TopParser();
    private SystemPropsParser mSystemPropsParser = new SystemPropsParser();
    private TracesParser mTracesParser = new TracesParser();
    private KernelLogParser mKernelLogParser = new KernelLogParser();
    private KernelLogParser mLastKmsgParser = new KernelLogParser();
    private LogcatParser mLogcatParser = new LogcatParser();
    private DumpsysParser mDumpsysParser = new DumpsysParser();
    private ActivityServiceParser mActivityServiceParser = new ActivityServiceParser();
    private BugreportItem mBugreport = null;
    private BugreportItem.CommandLineItem mCommandLine = new BugreportItem.CommandLineItem();
    private boolean mParsedInput = false;

    public BugreportItem parse(BufferedReader input) throws IOException {
        String line;
        this.setup();
        while ((line = input.readLine()) != null) {
            if (!this.mParsedInput && !"".equals(line.trim())) {
                this.mParsedInput = true;
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mBugreport;
    }

    @Override
    public BugreportItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            if (!this.mParsedInput && !"".equals(line.trim())) {
                this.mParsedInput = true;
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mBugreport;
    }

    protected void setup() {
        this.setParser(this.mBugreportParser);
        this.addSectionParser(this.mMemInfoParser, MEM_INFO_SECTION_REGEX);
        this.addSectionParser(this.mProcrankParser, PROCRANK_SECTION_REGEX);
        this.addSectionParser(this.mTopParser, TOP_SECTION_REGEX);
        this.addSectionParser(this.mSystemPropsParser, SYSTEM_PROP_SECTION_REGEX);
        this.addSectionParser(this.mTracesParser, ANR_TRACES_SECTION_REGEX);
        this.addSectionParser(this.mLogcatParser, SYSTEM_LOG_SECTION_REGEX);
        this.addSectionParser(this.mKernelLogParser, KERNEL_LOG_SECTION_REGEX);
        this.addSectionParser(this.mLastKmsgParser, LAST_KMSG_SECTION_REGEX);
        this.addSectionParser(this.mDumpsysParser, DUMPSYS_SECTION_REGEX);
        this.addSectionParser(this.mActivityServiceParser, ACTIVITY_SERVICE_SECTION_REGEX);
        this.addSectionParser(new NoopParser(), NOOP_SECTION_REGEX);
        this.mKernelLogParser.setAddUnknownBootreason(false);
        this.mLastKmsgParser.setAddUnknownBootreason(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void commit() {
        super.commit();
        if (this.mParsedInput && this.mBugreport == null) {
            this.mBugreport = new BugreportItem();
        }
        if (this.mBugreport != null) {
            void var2_5;
            KernelLogItem kernelLogItem;
            TracesItem traces;
            this.mBugreport.setCommandLine(this.mCommandLine);
            this.mBugreport.setMemInfo((MemInfoItem)this.getSection(this.mMemInfoParser));
            this.mBugreport.setProcrank((ProcrankItem)this.getSection(this.mProcrankParser));
            this.mBugreport.setTop((TopItem)this.getSection(this.mTopParser));
            this.mBugreport.setSystemLog((LogcatItem)this.getSection(this.mLogcatParser));
            this.mBugreport.setKernelLog((KernelLogItem)this.getSection(this.mKernelLogParser));
            this.mBugreport.setLastKmsg((KernelLogItem)this.getSection(this.mLastKmsgParser));
            this.mBugreport.setSystemProps((SystemPropsItem)this.getSection(this.mSystemPropsParser));
            this.mBugreport.setDumpsys((DumpsysItem)this.getSection(this.mDumpsysParser));
            this.mBugreport.setActivityService((ActivityServiceItem)this.getSection(this.mActivityServiceParser));
            if (this.mBugreport.getSystemLog() != null && this.mBugreport.getProcrank() != null) {
                for (IItem iItem : this.mBugreport.getSystemLog().getEvents()) {
                    if (!(iItem instanceof MiscLogcatItem) || ((MiscLogcatItem)iItem).getApp() != null) continue;
                    MiscLogcatItem logcatItem = (MiscLogcatItem)iItem;
                    logcatItem.setApp(this.mBugreport.getProcrank().getProcessName(logcatItem.getPid()));
                }
            }
            if ((traces = (TracesItem)this.getSection(this.mTracesParser)) != null && traces.getApp() != null && traces.getStack() != null && this.mBugreport.getSystemLog() != null) {
                this.addAnrTrace(this.mBugreport.getSystemLog().getAnrs(), traces.getApp(), traces.getStack());
            }
            if ((kernelLogItem = this.mBugreport.getLastKmsg()) == null) {
                KernelLogItem kernelLogItem2 = new KernelLogItem();
                this.mBugreport.setLastKmsg(kernelLogItem2);
            }
            String bootreason = null;
            if (this.mBugreport.getSystemProps() != null && this.mBugreport.getSystemProps().containsKey(BOOTREASON_PROP)) {
                bootreason = (String)this.mBugreport.getSystemProps().get(BOOTREASON_PROP);
            } else if (this.mCommandLine.containsKey(BOOTREASON_KERNEL)) {
                bootreason = (String)this.mCommandLine.get(BOOTREASON_KERNEL);
            }
            if (bootreason != null) {
                MiscKernelLogItem item;
                Matcher m = KernelLogParser.BAD_BOOTREASONS.matcher(bootreason);
                if (m.matches()) {
                    item = new MiscKernelLogItem();
                    item.setStack("Last boot reason: " + bootreason.trim());
                    item.setCategory("KERNEL_RESET");
                    item.setPreamble("");
                    item.setEventTime(0.0);
                    var2_5.addEvent(item);
                }
                if ((m = KernelLogParser.GOOD_BOOTREASONS.matcher(bootreason)).matches()) {
                    item = new MiscKernelLogItem();
                    item.setStack("Last boot reason: " + bootreason.trim());
                    item.setCategory("NORMAL_REBOOT");
                    var2_5.addEvent(item);
                }
            }
            if (var2_5.getMiscEvents("KERNEL_RESET").isEmpty() && var2_5.getMiscEvents("NORMAL_REBOOT").isEmpty()) {
                MiscKernelLogItem unknownReset = new MiscKernelLogItem();
                unknownReset.setStack("Unknown reason");
                unknownReset.setCategory("KERNEL_RESET");
                unknownReset.setPreamble("");
                unknownReset.setEventTime(0.0);
                var2_5.addEvent(unknownReset);
            }
        }
    }

    private void addAnrTrace(List<AnrItem> anrs, String app, String trace) {
        ListIterator<AnrItem> li = anrs.listIterator(anrs.size());
        while (li.hasPrevious()) {
            AnrItem anr = li.previous();
            if (!app.equals(anr.getApp())) continue;
            anr.setTrace(trace);
            return;
        }
    }

    @Override
    protected void onSwitchParser() {
        if (this.mBugreport == null) {
            this.mBugreport = (BugreportItem)this.getSection(this.mBugreportParser);
            if (this.mBugreport != null && this.mBugreport.getTime() != null) {
                this.mLogcatParser.setYear(new SimpleDateFormat("yyyy").format(this.mBugreport.getTime()));
            }
        }
    }

    private static Date parseTime(String timeStr) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return formatter.parse(timeStr);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

