/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.BatteryDischargeStatsInfoItem;
import com.android.loganalysis.item.BatteryStatsDetailedInfoItem;
import com.android.loganalysis.item.BatteryStatsSummaryInfoItem;
import com.android.loganalysis.item.DumpsysBatteryStatsItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.parser.BatteryDischargeStatsInfoParser;
import com.android.loganalysis.parser.BatteryStatsDetailedInfoParser;
import com.android.loganalysis.parser.BatteryStatsSummaryInfoParser;
import com.android.loganalysis.parser.NoopParser;
import java.util.List;

public class DumpsysBatteryStatsParser
extends AbstractSectionParser {
    private static final String SUMMARY_INFO_SECTION_REGEX = "Battery History \\(\\d+% used, \\d+(KB)? used of \\d+KB, \\d+ strings using \\d+(KB)?\\):$";
    private static final String DISCHARGE_STATS_INFO_SECTION_REGEX = "^Discharge step durations:$";
    private static final String DETAILED_INFO_SECTION_REGEX = "^Statistics since last charge:$";
    private static final String NOOP_SECTION_REGEX = "^(Statistics since last unplugged:|Daily stats:)$";
    private BatteryStatsSummaryInfoParser mSummaryParser = new BatteryStatsSummaryInfoParser();
    private BatteryStatsDetailedInfoParser mDetailedParser = new BatteryStatsDetailedInfoParser();
    private BatteryDischargeStatsInfoParser mDischargeStepsParser = new BatteryDischargeStatsInfoParser();
    private DumpsysBatteryStatsItem mDumpsysBatteryStatsItem = null;
    private boolean mParsedInput = false;

    @Override
    public DumpsysBatteryStatsItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            if (!this.mParsedInput && !"".equals(line.trim())) {
                this.mParsedInput = true;
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mDumpsysBatteryStatsItem;
    }

    protected void setup() {
        this.addSectionParser(this.mSummaryParser, SUMMARY_INFO_SECTION_REGEX);
        this.addSectionParser(this.mDetailedParser, DETAILED_INFO_SECTION_REGEX);
        this.addSectionParser(this.mDischargeStepsParser, DISCHARGE_STATS_INFO_SECTION_REGEX);
        this.addSectionParser(new NoopParser(), NOOP_SECTION_REGEX);
    }

    @Override
    protected void commit() {
        super.commit();
        if (this.mParsedInput && this.mDumpsysBatteryStatsItem == null) {
            this.mDumpsysBatteryStatsItem = new DumpsysBatteryStatsItem();
        }
        if (this.mDumpsysBatteryStatsItem != null) {
            this.mDumpsysBatteryStatsItem.setBatteryStatsSummarytem((BatteryStatsSummaryInfoItem)this.getSection(this.mSummaryParser));
            this.mDumpsysBatteryStatsItem.setDetailedBatteryStatsItem((BatteryStatsDetailedInfoItem)this.getSection(this.mDetailedParser));
            this.mDumpsysBatteryStatsItem.setBatteryDischargeStatsItem((BatteryDischargeStatsInfoItem)this.getSection(this.mDischargeStepsParser));
        }
    }
}

