/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.LatencyItem;
import com.android.loganalysis.item.TransitionDelayItem;
import com.android.loganalysis.parser.IParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventsLogParser
implements IParser {
    private static final Pattern SYSUI_TRANSITION_INFO_PATTERN = Pattern.compile("^(?<date>[0-9-]*)\\s+(?<time>[0-9:.]*)\\s+\\d+\\s+\\d+ I sysui_multi_action: \\[(?<transitioninfo>.*)\\]$");
    private static final Pattern ACTION_LATENCY = Pattern.compile("^(?<date>[0-9-]*)\\s+(?<time>[0-9:.]*)\\s+\\d+\\s+\\d+ I sysui_latency: \\[(?<action>.*),(?<delay>.*)\\]$");
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String TRANSITION_INFO = "transitioninfo";
    private static final String PACKAGE_KEY = "806";
    private static final String ACTIVITY_KEY = "871";
    private static final String TRANSITION_DELAY_KEY = "319";
    private static final String STARTING_WINDOW_DELAY_KEY = "321";
    private static final String COLD_LAUNCH_KEY = "945";
    private static final String WINDOWS_DRAWN_DELAY_KEY = "322";

    @Override
    public IItem parse(List<String> lines) {
        throw new UnsupportedOperationException("Method has not been implemented in lieu of others");
    }

    public List<TransitionDelayItem> parseTransitionDelayInfo(BufferedReader input) throws IOException {
        String line;
        ArrayList<TransitionDelayItem> transitionDelayItems = new ArrayList<TransitionDelayItem>();
        Matcher match = null;
        while ((line = input.readLine()) != null) {
            Map<String, String> transitionInfoMap;
            match = EventsLogParser.matches(SYSUI_TRANSITION_INFO_PATTERN, line);
            if (match == null || !(transitionInfoMap = this.getTransitionInfoMap(match.group(TRANSITION_INFO))).containsKey(TRANSITION_DELAY_KEY)) continue;
            TransitionDelayItem delayItem = new TransitionDelayItem();
            if (null != transitionInfoMap.get(PACKAGE_KEY) && null != transitionInfoMap.get(ACTIVITY_KEY) && null != transitionInfoMap.get(TRANSITION_DELAY_KEY) && null != transitionInfoMap.get(WINDOWS_DRAWN_DELAY_KEY)) {
                delayItem.setComponentName(transitionInfoMap.get(PACKAGE_KEY) + "/" + transitionInfoMap.get(ACTIVITY_KEY));
                delayItem.setTransitionDelay(Long.parseLong(transitionInfoMap.get(TRANSITION_DELAY_KEY)));
                delayItem.setDateTime(String.format("%s %s", match.group(DATE), match.group(TIME)));
                delayItem.setWindowDrawnDelay(Long.parseLong(transitionInfoMap.get(WINDOWS_DRAWN_DELAY_KEY)));
            }
            if (transitionInfoMap.containsKey(COLD_LAUNCH_KEY) && null != transitionInfoMap.get(STARTING_WINDOW_DELAY_KEY)) {
                delayItem.setStartingWindowDelay(Long.parseLong(transitionInfoMap.get(STARTING_WINDOW_DELAY_KEY)));
            }
            transitionDelayItems.add(delayItem);
        }
        return transitionDelayItems;
    }

    public Map<String, String> getTransitionInfoMap(String transitionInfo) {
        String[] transitionSplit = transitionInfo.split(",");
        HashMap<String, String> transitionInfoMap = new HashMap<String, String>();
        if (transitionSplit.length % 2 == 0) {
            for (int i = 0; i < transitionSplit.length; i += 2) {
                transitionInfoMap.put(transitionSplit[i], transitionSplit[i + 1]);
            }
        }
        return transitionInfoMap;
    }

    public List<LatencyItem> parseLatencyInfo(BufferedReader input) throws IOException {
        String line;
        ArrayList<LatencyItem> latencyItems = new ArrayList<LatencyItem>();
        while ((line = input.readLine()) != null) {
            Matcher match = null;
            match = EventsLogParser.matches(ACTION_LATENCY, line);
            if (match == null) continue;
            LatencyItem latencyItem = new LatencyItem();
            latencyItem.setActionId(Integer.parseInt(match.group("action")));
            latencyItem.setDelay(Long.parseLong(match.group("delay")));
            latencyItems.add(latencyItem);
        }
        return latencyItems;
    }

    private static Matcher matches(Pattern pattern, String line) {
        Matcher ret = pattern.matcher(line);
        return ret.matches() ? ret : null;
    }
}

