/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.GfxInfoItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GfxInfoParser
implements IParser {
    private static final Pattern PID_PREFIX = Pattern.compile("\\*\\* Graphics info for pid (\\d+) \\[(.+)\\] \\*\\*");
    private static final Pattern TOTAL_FRAMES_PREFIX = Pattern.compile("Total frames rendered: (\\d+)");
    private static final Pattern JANKY_FRAMES_PREFIX = Pattern.compile("Janky frames: (\\d+) \\(.+\\%\\)");
    private static final Pattern PERCENTILE_90_PREFIX = Pattern.compile("90th percentile: (\\d+)ms");
    private static final Pattern PERCENTILE_95_PREFIX = Pattern.compile("95th percentile: (\\d+)ms");
    private static final Pattern PERCENTILE_99_PREFIX = Pattern.compile("99th percentile: (\\d+)ms");

    @Override
    public GfxInfoItem parse(List<String> lines) {
        GfxInfoItem item = new GfxInfoItem();
        String name = null;
        Integer pid = null;
        Long totalFrames = null;
        Long jankyFrames = null;
        Integer percentile90 = null;
        Integer percentile95 = null;
        Integer percentile99 = null;
        for (String line : lines) {
            Matcher m = PID_PREFIX.matcher(line);
            if (m.matches() && m.groupCount() == 2) {
                pid = Integer.parseInt(m.group(1));
                name = m.group(2);
                totalFrames = null;
                jankyFrames = null;
                percentile90 = null;
                percentile95 = null;
                percentile99 = null;
            }
            m = TOTAL_FRAMES_PREFIX.matcher(line);
            if (totalFrames == null && m.matches()) {
                totalFrames = Long.parseLong(m.group(1));
            }
            m = JANKY_FRAMES_PREFIX.matcher(line);
            if (jankyFrames == null && m.matches()) {
                jankyFrames = Long.parseLong(m.group(1));
            }
            m = PERCENTILE_90_PREFIX.matcher(line);
            if (percentile90 == null && m.matches()) {
                percentile90 = Integer.parseInt(m.group(1));
            }
            m = PERCENTILE_95_PREFIX.matcher(line);
            if (percentile95 == null && m.matches()) {
                percentile95 = Integer.parseInt(m.group(1));
            }
            m = PERCENTILE_99_PREFIX.matcher(line);
            if (percentile99 == null && m.matches()) {
                percentile99 = Integer.parseInt(m.group(1));
            }
            if (name == null || pid == null || totalFrames == null || jankyFrames == null || percentile90 == null || percentile95 == null || percentile99 == null) continue;
            item.addRow(pid, name, totalFrames, jankyFrames, percentile90, percentile95, percentile99);
            name = null;
            pid = null;
            totalFrames = null;
            jankyFrames = null;
            percentile90 = null;
            percentile95 = null;
            percentile99 = null;
        }
        return item;
    }
}

