/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.InterruptItem;
import com.android.loganalysis.parser.IParser;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InterruptParser
implements IParser {
    private static final Pattern Interrupt = Pattern.compile("^\\s*Wakeup reason (.*): (?:\\d+h )?(?:\\d+m )?(?:\\d+s )(?:\\d+ms )\\((\\d+) times\\) realtime");
    private InterruptItem mItem = new InterruptItem();

    @Override
    public InterruptItem parse(List<String> lines) {
        String line;
        Matcher m;
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext() && (m = Interrupt.matcher(line = iterator.next())).matches()) {
            String interruptName = m.group(1);
            int interruptCount = Integer.parseInt(m.group(2));
            this.mItem.addInterrupt(interruptName, interruptCount, this.getInterruptCategory(interruptName));
        }
        return this.mItem;
    }

    InterruptItem getItem() {
        return this.mItem;
    }

    private InterruptItem.InterruptCategory getInterruptCategory(String interruptName) {
        if (interruptName.contains("bcmsdh_sdmmc") || interruptName.contains("msm_pcie_wake")) {
            return InterruptItem.InterruptCategory.WIFI_INTERRUPT;
        }
        if (interruptName.contains("smd-modem") || interruptName.contains("smsm-modem")) {
            return InterruptItem.InterruptCategory.MODEM_INTERRUPT;
        }
        if (interruptName.contains("smd-adsp")) {
            return InterruptItem.InterruptCategory.ADSP_INTERRUPT;
        }
        if (interruptName.contains("max77686-irq") || interruptName.contains("cpcap-irq") || interruptName.contains("TWL6030-PIH")) {
            return InterruptItem.InterruptCategory.ALARM_INTERRUPT;
        }
        return InterruptItem.InterruptCategory.UNKNOWN_INTERRUPT;
    }
}

