/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.TracesItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TracesParser
implements IParser {
    private static final Pattern PID = Pattern.compile("^----- pid (\\d+) at \\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2} -----$");
    private static final Pattern APP = Pattern.compile("^Cmd ?line: (\\S+).*$");
    private static final Pattern STACK = Pattern.compile("^\"main\" .*$");

    @Override
    public TracesItem parse(List<String> lines) {
        TracesItem traces = new TracesItem();
        StringBuffer stack = null;
        for (String line : lines) {
            if (stack == null) {
                Matcher m = PID.matcher(line);
                if (m.matches()) {
                    traces.setPid(Integer.parseInt(m.group(1)));
                }
                if ((m = APP.matcher(line)).matches()) {
                    traces.setApp(m.group(1));
                }
                if (!(m = STACK.matcher(line)).matches()) continue;
                stack = new StringBuffer();
                stack.append(line);
                stack.append("\n");
                continue;
            }
            if (!"".equals(line)) {
                stack.append(line);
                stack.append("\n");
                continue;
            }
            traces.setStack(stack.toString().trim());
            return traces;
        }
        if (stack == null) {
            return null;
        }
        traces.setStack(stack.toString().trim());
        return traces;
    }
}

