/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.BackupUtils;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.INativeDevice;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class BackupHostSideUtils {
    private static final int USER_SYSTEM = 0;
    private static final String USER_SETUP_COMPLETE = "user_setup_complete";

    public static BackupUtils createBackupUtils(final INativeDevice device) {
        return new BackupUtils(){

            @Override
            protected InputStream executeShellCommand(String command) throws IOException {
                try {
                    String result = device.executeShellCommand(command);
                    return new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
                }
                catch (DeviceNotAvailableException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public static void checkSetupComplete(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        if (!BackupHostSideUtils.isSetupCompleteSettingForSystemUser(device)) {
            throw new TargetSetupError("Backup tests cannot be run:Setup not completed for system user", device.getDeviceDescriptor());
        }
    }

    private static boolean isSetupCompleteSettingForSystemUser(ITestDevice device) throws DeviceNotAvailableException {
        return device.getSetting(0, "secure", USER_SETUP_COMPLETE).equals("1");
    }
}

