/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.AssumptionViolatedException;

public abstract class BusinessLogicExecutor {
    protected static final String LOG_TAG = "BusinessLogicExecutor";
    protected static final String STRING_CLASS = "java.lang.String";
    protected static final String STRING_ARRAY_CLASS = "[Ljava.lang.String;";
    private static final String REDACTED_PLACEHOLDER = "[redacted]";
    protected List<String> mRedactionRegexes = new ArrayList<String>();

    public boolean executeCondition(String method, String ... args) {
        this.logDebug("Executing condition: %s", this.formatExecutionString(method, args));
        try {
            return (Boolean)this.invokeMethod(method, args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("BusinessLogic: Failed to invoke condition method %s with args: %s", method, Arrays.toString(args)), e);
        }
    }

    public void executeAction(String method, String ... args) {
        this.logDebug("Executing action: %s", this.formatExecutionString(method, args));
        try {
            this.invokeMethod(method, args);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(String.format("BusinessLogic: Failed to invoke action method %s with args: %s", method, Arrays.toString(args)), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (AssumptionViolatedException.class.isInstance(t)) {
                throw (AssumptionViolatedException)t;
            }
            RuntimeException re = new RuntimeException(t.getMessage(), t.getCause());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    protected abstract String formatExecutionString(String var1, String ... var2);

    protected String[] formatArgs(String[] args) {
        ArrayList<String> formattedArgs = new ArrayList<String>();
        for (String arg : args) {
            formattedArgs.add(this.formatArg(arg));
        }
        return formattedArgs.toArray(new String[0]);
    }

    private String formatArg(String arg) {
        for (String regex : this.mRedactionRegexes) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(arg);
            if (!matcher.find()) continue;
            return REDACTED_PLACEHOLDER;
        }
        return arg;
    }

    protected Object invokeMethod(String method, String ... args) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        int index;
        int n = index = method.indexOf(35) == -1 ? method.lastIndexOf(46) : method.indexOf(35);
        if (index == -1) {
            throw new RuntimeException(String.format("BusinessLogic: invalid method name \"%s\". Method string must include fully qualified class name. For example, \"com.android.packagename.ClassName.methodName\".", method));
        }
        String className = method.substring(0, index);
        Class<?> cls = Class.forName(className);
        Object obj = null;
        obj = this.getTestObject() != null && cls.isAssignableFrom(this.getTestObject().getClass()) ? this.getTestObject() : (Object)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ResolvedMethod rm = this.getResolvedMethod(cls, method.substring(index + 1), args);
        return rm.invoke(obj);
    }

    public abstract void logInfo(String var1, Object ... var2);

    public abstract void logDebug(String var1, Object ... var2);

    protected abstract Object getTestObject();

    protected abstract ResolvedMethod getResolvedMethod(Class var1, String var2, String ... var3) throws ClassNotFoundException;

    protected List<Method> getMethodsWithName(Class cls, String name) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method m : cls.getMethods()) {
            if (!name.equals(m.getName())) continue;
            methodList.add(m);
        }
        return methodList;
    }

    protected static class ResolvedMethod {
        private Method mMethod;
        List<Object> mArgs;

        public ResolvedMethod(Method method) {
            this.mMethod = method;
            this.mArgs = new ArrayList<Object>();
        }

        public void addArg(Object arg) {
            this.mArgs.add(arg);
        }

        public Object invoke(Object instance) throws IllegalAccessException, InvocationTargetException {
            return this.mMethod.invoke(instance, this.mArgs.toArray());
        }
    }
}

