/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.MetricsStore;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.ReportLogHostInfoStore;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.List;

public final class MetricsReportLog
extends ReportLog {
    private final String mAbi;
    private final String mClassMethodName;
    private final IBuildInfo mBuildInfo;
    private static final String TEMPORARY_REPORT_FOLDER = "temp-report-logs";
    private ReportLogHostInfoStore store;

    public MetricsReportLog(IBuildInfo buildInfo, String abi, String classMethodName, String reportLogName, String streamName) {
        this(buildInfo, abi, classMethodName, reportLogName, streamName, false);
    }

    public MetricsReportLog(IBuildInfo buildInfo, String abi, String classMethodName, String reportLogName, String streamName, boolean deviceDir) {
        super(reportLogName, streamName);
        this.mBuildInfo = buildInfo;
        this.mAbi = abi;
        this.mClassMethodName = classMethodName;
        try {
            String tmpDirName = TEMPORARY_REPORT_FOLDER;
            if (deviceDir) {
                tmpDirName = tmpDirName + "-" + buildInfo.getDeviceSerial();
            }
            File dir = FileUtil.createNamedTempDir((String)tmpDirName);
            File jsonFile = new File(dir, this.mReportLogName + ".reportlog.json");
            this.store = new ReportLogHostInfoStore(jsonFile, this.mStreamName);
            this.store.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String source, String message, double value, ResultType type, ResultUnit unit) {
        super.addValue(source, message, value, type, unit);
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, double value, ResultType type, ResultUnit unit) {
        super.addValue(message, value, type, unit);
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String source, String message, double[] values, ResultType type, ResultUnit unit) {
        super.addValues(source, message, values, type, unit);
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, double[] values, ResultType type, ResultUnit unit) {
        super.addValues(message, values, type, unit);
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, int value, ResultType type, ResultUnit unit) {
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, long value, ResultType type, ResultUnit unit) {
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, float value, ResultType type, ResultUnit unit) {
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, boolean value, ResultType type, ResultUnit unit) {
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValue(String message, String value, ResultType type, ResultUnit unit) {
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, int[] values, ResultType type, ResultUnit unit) {
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, long[] values, ResultType type, ResultUnit unit) {
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, float[] values, ResultType type, ResultUnit unit) {
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, boolean[] values, ResultType type, ResultUnit unit) {
        try {
            this.store.addArrayResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addValues(String message, List<String> values, ResultType type, ResultUnit unit) {
        try {
            this.store.addListResult(message, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSummary(String message, double value, ResultType type, ResultUnit unit) {
        super.setSummary(message, value, type, unit);
        try {
            this.store.addResult(message, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void submit() {
        try {
            this.store.close();
            MetricsStore.storeResult(this.mBuildInfo, this.mAbi, this.mClassMethodName, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

