/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ReportLog;
import com.android.tradefed.build.IBuildInfo;
import java.util.concurrent.ConcurrentHashMap;

public class MetricsStore {
    private static final ConcurrentHashMap<String, ReportLog> mMap = new ConcurrentHashMap();
    private static final String START_TIME_TAG = "START_TIME_MS";

    private MetricsStore() {
    }

    public static void storeResult(IBuildInfo buildInfo, String abi, String classMethodName, ReportLog reportLog) {
        String startTime = (String)buildInfo.getBuildAttributes().get(START_TIME_TAG);
        mMap.put(MetricsStore.generateTestKey(startTime, abi, classMethodName), reportLog);
    }

    public static ReportLog removeResult(IBuildInfo buildInfo, String abi, String classMethodName) {
        String startTime = (String)buildInfo.getBuildAttributes().get(START_TIME_TAG);
        return mMap.remove(MetricsStore.generateTestKey(startTime, abi, classMethodName));
    }

    private static String generateTestKey(String startTime, String abi, String classMethodName) {
        return String.format("%s#%s#%s", startTime, abi, classMethodName);
    }
}

