/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.AbiUtils;
import com.android.compatibility.common.util.ChecksumReporter;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.InvocationResult;
import com.android.compatibility.common.util.LightInvocationResult;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.RetryChecksumStatus;
import com.android.compatibility.common.util.TestResultHistory;
import com.android.compatibility.common.util.TestStatus;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ResultHandler {
    private static final String ENCODING = "UTF-8";
    private static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
    private static final String NS = null;
    private static final String RESULT_FILE_VERSION = "5.0";
    public static final String TEST_RESULT_FILE_NAME = "test_result.xml";
    public static final String FAILURE_REPORT_NAME = "test_result_failures.html";
    private static final String FAILURE_XSL_FILE_NAME = "compatibility_failures.xsl";
    public static final String[] RESULT_RESOURCES = new String[]{"compatibility_result.css", "compatibility_result.xsd", "compatibility_result.xsl", "logo.png"};
    private static final String ABI_ATTR = "abi";
    private static final String BUGREPORT_TAG = "BugReport";
    private static final String BUILD_FINGERPRINT = "build_fingerprint";
    private static final String BUILD_FINGERPRINT_UNALTERED = "build_fingerprint_unaltered";
    private static final String BUILD_ID = "build_id";
    private static final String BUILD_PRODUCT = "build_product";
    private static final String BUILD_TAG = "Build";
    private static final String CASE_TAG = "TestCase";
    private static final String COMMAND_LINE_ARGS = "command_line_args";
    private static final String DEVICES_ATTR = "devices";
    private static final String DONE_ATTR = "done";
    private static final String END_DISPLAY_TIME_ATTR = "end_display";
    private static final String END_TIME_ATTR = "end";
    private static final String FAILED_ATTR = "failed";
    private static final String FAILURE_TAG = "Failure";
    private static final String HOST_NAME_ATTR = "host_name";
    private static final String JAVA_VENDOR_ATTR = "java_vendor";
    private static final String JAVA_VERSION_ATTR = "java_version";
    private static final String LOGCAT_TAG = "Logcat";
    private static final String LOG_URL_ATTR = "log_url";
    private static final String MESSAGE_ATTR = "message";
    private static final String MODULE_TAG = "Module";
    private static final String MODULES_DONE_ATTR = "modules_done";
    private static final String MODULES_TOTAL_ATTR = "modules_total";
    private static final String MODULES_NOT_DONE_REASON = "Reason";
    private static final String NAME_ATTR = "name";
    private static final String OS_ARCH_ATTR = "os_arch";
    private static final String OS_NAME_ATTR = "os_name";
    private static final String OS_VERSION_ATTR = "os_version";
    private static final String PASS_ATTR = "pass";
    private static final String REPORT_VERSION_ATTR = "report_version";
    private static final String REFERENCE_URL_ATTR = "reference_url";
    private static final String RESULT_ATTR = "result";
    private static final String RESULT_TAG = "Result";
    private static final String RUNTIME_ATTR = "runtime";
    private static final String RUN_HISTORY_ATTR = "run_history";
    private static final String RUN_HISTORY_TAG = "RunHistory";
    private static final String RUN_TAG = "Run";
    private static final String SCREENSHOT_TAG = "Screenshot";
    private static final String SKIPPED_ATTR = "skipped";
    private static final String STACK_TAG = "StackTrace";
    private static final String START_DISPLAY_TIME_ATTR = "start_display";
    private static final String START_TIME_ATTR = "start";
    private static final String SUITE_NAME_ATTR = "suite_name";
    private static final String SUITE_PLAN_ATTR = "suite_plan";
    private static final String SUITE_VERSION_ATTR = "suite_version";
    private static final String SUITE_BUILD_ATTR = "suite_build_number";
    private static final String SUMMARY_TAG = "Summary";
    private static final String METRIC_TAG = "Metric";
    private static final String TEST_TAG = "Test";
    private static final String LATEST_RESULT_DIR = "latest";

    public static List<IInvocationResult> getLightResults(File resultsDir) {
        ArrayList<IInvocationResult> results = new ArrayList<IInvocationResult>();
        List<File> files = ResultHandler.getResultDirectories(resultsDir);
        for (File resultDir : files) {
            IInvocationResult result;
            if (LATEST_RESULT_DIR.equals(resultDir.getName()) || (result = ResultHandler.getResultFromDir(resultDir, false)) == null) continue;
            results.add(new LightInvocationResult(result));
            result = null;
        }
        Collections.sort(results, (result1, result2) -> Long.compare(result1.getStartTime(), result2.getStartTime()));
        return results;
    }

    public static IInvocationResult getResultFromDir(File resultDir) {
        return ResultHandler.getResultFromDir(resultDir, false);
    }

    public static IInvocationResult getResultFromDir(File resultDir, Boolean useChecksum) {
        File resultFile = null;
        try {
            resultFile = new File(resultDir, TEST_RESULT_FILE_NAME);
            if (!resultFile.exists()) {
                return null;
            }
            Boolean invocationUseChecksum = useChecksum;
            InvocationResult invocation = new InvocationResult();
            invocation.setRetryDirectory(resultDir);
            ChecksumReporter checksumReporter = null;
            if (invocationUseChecksum.booleanValue()) {
                try {
                    checksumReporter = ChecksumReporter.load(resultDir);
                    invocation.setRetryChecksumStatus(RetryChecksumStatus.RetryWithChecksum);
                }
                catch (ChecksumReporter.ChecksumValidationException e) {
                    invocation.setRetryChecksumStatus(RetryChecksumStatus.RetryWithoutChecksum);
                    invocationUseChecksum = false;
                }
            }
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)new FileReader(resultFile));
            parser.nextTag();
            parser.require(2, NS, RESULT_TAG);
            invocation.setStartTime(Long.valueOf(parser.getAttributeValue(NS, START_TIME_ATTR)));
            invocation.setTestPlan(parser.getAttributeValue(NS, SUITE_PLAN_ATTR));
            invocation.setCommandLineArgs(parser.getAttributeValue(NS, COMMAND_LINE_ARGS));
            String deviceList = parser.getAttributeValue(NS, DEVICES_ATTR);
            for (String device : deviceList.split(",")) {
                invocation.addDeviceSerial(device);
            }
            parser.nextTag();
            parser.require(2, NS, BUILD_TAG);
            invocation.addInvocationInfo(BUILD_ID, parser.getAttributeValue(NS, BUILD_ID));
            invocation.addInvocationInfo(BUILD_PRODUCT, parser.getAttributeValue(NS, BUILD_PRODUCT));
            String runHistoryValue = parser.getAttributeValue(NS, RUN_HISTORY_ATTR);
            if (runHistoryValue != null) {
                invocation.addInvocationInfo(RUN_HISTORY_ATTR, runHistoryValue);
            }
            String reportFingerprint = parser.getAttributeValue(NS, BUILD_FINGERPRINT);
            String unalteredFingerprint = parser.getAttributeValue(NS, BUILD_FINGERPRINT_UNALTERED);
            Boolean fingerprintWasAltered = !Strings.isNullOrEmpty((String)unalteredFingerprint);
            invocation.setBuildFingerprint(fingerprintWasAltered != false ? unalteredFingerprint : reportFingerprint);
            parser.nextTag();
            parser.require(3, NS, BUILD_TAG);
            parser.nextTag();
            boolean hasRunHistoryTag = true;
            try {
                parser.require(2, NS, RUN_HISTORY_TAG);
            }
            catch (XmlPullParserException e) {
                hasRunHistoryTag = false;
            }
            if (hasRunHistoryTag) {
                ResultHandler.parseRunHistory(parser);
            }
            parser.require(2, NS, SUMMARY_TAG);
            parser.nextTag();
            parser.require(3, NS, SUMMARY_TAG);
            while (parser.nextTag() == 2) {
                parser.require(2, NS, MODULE_TAG);
                String name = parser.getAttributeValue(NS, NAME_ATTR);
                String abi = parser.getAttributeValue(NS, ABI_ATTR);
                String moduleId = AbiUtils.createId(abi, name);
                boolean done = Boolean.parseBoolean(parser.getAttributeValue(NS, DONE_ATTR));
                IModuleResult module = invocation.getOrCreateModule(moduleId);
                module.initializeDone(done);
                long runtime = Long.parseLong(parser.getAttributeValue(NS, RUNTIME_ATTR));
                module.addRuntime(runtime);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals(MODULES_NOT_DONE_REASON)) {
                        parser.require(2, NS, MODULES_NOT_DONE_REASON);
                        parser.nextTag();
                        parser.require(3, NS, MODULES_NOT_DONE_REASON);
                        continue;
                    }
                    parser.require(2, NS, CASE_TAG);
                    String caseName = parser.getAttributeValue(NS, NAME_ATTR);
                    ICaseResult testCase = module.getOrCreateResult(caseName);
                    while (parser.nextTag() == 2) {
                        parser.require(2, NS, TEST_TAG);
                        String testName = parser.getAttributeValue(NS, NAME_ATTR);
                        ITestResult test = testCase.getOrCreateResult(testName);
                        String result = parser.getAttributeValue(NS, RESULT_ATTR);
                        String skipped = parser.getAttributeValue(NS, SKIPPED_ATTR);
                        if (skipped != null && Boolean.parseBoolean(skipped)) {
                            test.skipped();
                        } else {
                            test.setResultStatus(TestStatus.getStatus(result));
                        }
                        test.setRetry(true);
                        while (parser.nextTag() == 2) {
                            if (parser.getName().equals(FAILURE_TAG)) {
                                test.setMessage(parser.getAttributeValue(NS, MESSAGE_ATTR));
                                if (parser.nextTag() == 2) {
                                    parser.require(2, NS, STACK_TAG);
                                    test.setStackTrace(parser.nextText());
                                    parser.require(3, NS, STACK_TAG);
                                    parser.nextTag();
                                }
                                parser.require(3, NS, FAILURE_TAG);
                                continue;
                            }
                            if (parser.getName().equals(BUGREPORT_TAG)) {
                                test.setBugReport(parser.nextText());
                                parser.require(3, NS, BUGREPORT_TAG);
                                continue;
                            }
                            if (parser.getName().equals(LOGCAT_TAG)) {
                                test.setLog(parser.nextText());
                                parser.require(3, NS, LOGCAT_TAG);
                                continue;
                            }
                            if (parser.getName().equals(SCREENSHOT_TAG)) {
                                test.setScreenshot(parser.nextText());
                                parser.require(3, NS, SCREENSHOT_TAG);
                                continue;
                            }
                            if (SUMMARY_TAG.equals(parser.getName())) {
                                test.setReportLog(ReportLog.parse(parser));
                                continue;
                            }
                            if (METRIC_TAG.equals(parser.getName())) {
                                parser.nextText();
                                parser.require(3, NS, METRIC_TAG);
                                continue;
                            }
                            if (RUN_HISTORY_TAG.equals(parser.getName())) {
                                ResultHandler.skipCurrentTag(parser);
                                continue;
                            }
                            parser.nextTag();
                        }
                        parser.require(3, NS, TEST_TAG);
                        Boolean checksumMismatch = invocationUseChecksum != false && !checksumReporter.containsTestResult(test, module, reportFingerprint) && (fingerprintWasAltered == false || !checksumReporter.containsTestResult(test, module, unalteredFingerprint));
                        if (!checksumMismatch.booleanValue()) continue;
                        test.removeResult();
                    }
                    parser.require(3, NS, CASE_TAG);
                }
                parser.require(3, NS, MODULE_TAG);
                Boolean checksumMismatch = invocationUseChecksum != false && checksumReporter.containsModuleResult(module, reportFingerprint) == false && (fingerprintWasAltered == false || checksumReporter.containsModuleResult(module, unalteredFingerprint) == false);
                if (!checksumMismatch.booleanValue()) continue;
                module.initializeDone(false);
            }
            parser.require(3, NS, RESULT_TAG);
            return invocation;
        }
        catch (IOException | XmlPullParserException e) {
            System.out.println(String.format("Exception when trying to load %s", resultFile.getAbsolutePath()));
            e.printStackTrace();
            return null;
        }
    }

    private static void parseRunHistory(XmlPullParser parser) throws IOException, XmlPullParserException {
        while (parser.nextTag() == 2) {
            parser.require(2, NS, RUN_TAG);
            parser.nextTag();
            parser.require(3, NS, RUN_TAG);
        }
        parser.require(3, NS, RUN_HISTORY_TAG);
        parser.nextTag();
    }

    private static void skipCurrentTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    public static File writeResults(String suiteName, String suiteVersion, String suitePlan, String suiteBuild, IInvocationResult result, File resultDir, long startTime, long endTime, String referenceUrl, String logUrl, String commandLineArgs, Map<String, String> resultAttributes) throws IOException, XmlPullParserException {
        int passed = result.countResults(TestStatus.PASS);
        int failed = result.countResults(TestStatus.FAIL);
        File resultFile = new File(resultDir, TEST_RESULT_FILE_NAME);
        FileOutputStream stream = new FileOutputStream(resultFile);
        XmlSerializer serializer = XmlPullParserFactory.newInstance((String)TYPE, null).newSerializer();
        serializer.setOutput((OutputStream)stream, ENCODING);
        serializer.startDocument(ENCODING, Boolean.valueOf(false));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.processingInstruction("xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"");
        serializer.startTag(NS, RESULT_TAG);
        serializer.attribute(NS, START_TIME_ATTR, String.valueOf(startTime));
        serializer.attribute(NS, END_TIME_ATTR, String.valueOf(endTime));
        serializer.attribute(NS, START_DISPLAY_TIME_ATTR, ResultHandler.toReadableDateString(startTime));
        serializer.attribute(NS, END_DISPLAY_TIME_ATTR, ResultHandler.toReadableDateString(endTime));
        serializer.attribute(NS, SUITE_NAME_ATTR, suiteName);
        serializer.attribute(NS, SUITE_VERSION_ATTR, suiteVersion);
        serializer.attribute(NS, SUITE_PLAN_ATTR, suitePlan);
        serializer.attribute(NS, SUITE_BUILD_ATTR, suiteBuild);
        serializer.attribute(NS, REPORT_VERSION_ATTR, RESULT_FILE_VERSION);
        serializer.attribute(NS, COMMAND_LINE_ARGS, ResultHandler.nullToEmpty(commandLineArgs));
        if (resultAttributes != null) {
            for (Map.Entry<String, String> entry : resultAttributes.entrySet()) {
                serializer.attribute(NS, entry.getKey(), entry.getValue());
            }
        }
        if (referenceUrl != null) {
            serializer.attribute(NS, REFERENCE_URL_ATTR, referenceUrl);
        }
        if (logUrl != null) {
            serializer.attribute(NS, LOG_URL_ATTR, logUrl);
        }
        Set<String> devices = result.getDeviceSerials();
        StringBuilder deviceList = new StringBuilder();
        boolean first = true;
        for (String string : devices) {
            if (first) {
                first = false;
            } else {
                deviceList.append(",");
            }
            deviceList.append(string);
        }
        serializer.attribute(NS, DEVICES_ATTR, deviceList.toString());
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        serializer.attribute(NS, HOST_NAME_ATTR, hostName);
        serializer.attribute(NS, OS_NAME_ATTR, System.getProperty("os.name"));
        serializer.attribute(NS, OS_VERSION_ATTR, System.getProperty("os.version"));
        serializer.attribute(NS, OS_ARCH_ATTR, System.getProperty("os.arch"));
        serializer.attribute(NS, JAVA_VENDOR_ATTR, System.getProperty("java.vendor"));
        serializer.attribute(NS, JAVA_VERSION_ATTR, System.getProperty("java.version"));
        serializer.startTag(NS, BUILD_TAG);
        for (Map.Entry<String, String> entry : result.getInvocationInfo().entrySet()) {
            serializer.attribute(NS, entry.getKey(), entry.getValue());
            if (!Strings.isNullOrEmpty((String)result.getBuildFingerprint()) || !entry.getKey().equals(BUILD_FINGERPRINT)) continue;
            result.setBuildFingerprint(entry.getValue());
        }
        serializer.endTag(NS, BUILD_TAG);
        Collection<InvocationResult.RunHistory> collection = ((InvocationResult)result).getRunHistories();
        if (!collection.isEmpty()) {
            serializer.startTag(NS, RUN_HISTORY_TAG);
            for (InvocationResult.RunHistory runHistory : collection) {
                serializer.startTag(NS, RUN_TAG);
                serializer.attribute(NS, START_TIME_ATTR, String.valueOf(runHistory.startTime));
                serializer.attribute(NS, END_TIME_ATTR, String.valueOf(runHistory.endTime));
                serializer.endTag(NS, RUN_TAG);
            }
            serializer.endTag(NS, RUN_HISTORY_TAG);
        }
        serializer.startTag(NS, SUMMARY_TAG);
        serializer.attribute(NS, PASS_ATTR, Integer.toString(passed));
        serializer.attribute(NS, FAILED_ATTR, Integer.toString(failed));
        serializer.attribute(NS, MODULES_DONE_ATTR, Integer.toString(result.getModuleCompleteCount()));
        serializer.attribute(NS, MODULES_TOTAL_ATTR, Integer.toString(result.getModules().size()));
        serializer.endTag(NS, SUMMARY_TAG);
        for (IModuleResult module : result.getModules()) {
            serializer.startTag(NS, MODULE_TAG);
            serializer.attribute(NS, NAME_ATTR, module.getName());
            serializer.attribute(NS, ABI_ATTR, module.getAbi());
            serializer.attribute(NS, RUNTIME_ATTR, String.valueOf(module.getRuntime()));
            serializer.attribute(NS, DONE_ATTR, Boolean.toString(module.isDone()));
            serializer.attribute(NS, PASS_ATTR, Integer.toString(module.countResults(TestStatus.PASS)));
            for (ICaseResult cr : module.getResults()) {
                serializer.startTag(NS, CASE_TAG);
                serializer.attribute(NS, NAME_ATTR, cr.getName());
                for (ITestResult r : cr.getResults()) {
                    List<TestResultHistory> testResultHistories;
                    ReportLog report;
                    String screenshot;
                    String logcat;
                    String bugreport;
                    String message;
                    TestStatus status = r.getResultStatus();
                    if (status == null) continue;
                    serializer.startTag(NS, TEST_TAG);
                    serializer.attribute(NS, RESULT_ATTR, status.getValue());
                    serializer.attribute(NS, NAME_ATTR, r.getName());
                    if (r.isSkipped()) {
                        serializer.attribute(NS, SKIPPED_ATTR, Boolean.toString(true));
                    }
                    if ((message = r.getMessage()) != null) {
                        serializer.startTag(NS, FAILURE_TAG);
                        serializer.attribute(NS, MESSAGE_ATTR, message);
                        String stackTrace = r.getStackTrace();
                        if (stackTrace != null) {
                            serializer.startTag(NS, STACK_TAG);
                            serializer.text(stackTrace);
                            serializer.endTag(NS, STACK_TAG);
                        }
                        serializer.endTag(NS, FAILURE_TAG);
                    }
                    if ((bugreport = r.getBugReport()) != null) {
                        serializer.startTag(NS, BUGREPORT_TAG);
                        serializer.text(bugreport);
                        serializer.endTag(NS, BUGREPORT_TAG);
                    }
                    if ((logcat = r.getLog()) != null) {
                        serializer.startTag(NS, LOGCAT_TAG);
                        serializer.text(logcat);
                        serializer.endTag(NS, LOGCAT_TAG);
                    }
                    if ((screenshot = r.getScreenshot()) != null) {
                        serializer.startTag(NS, SCREENSHOT_TAG);
                        serializer.text(screenshot);
                        serializer.endTag(NS, SCREENSHOT_TAG);
                    }
                    if ((report = r.getReportLog()) != null) {
                        ReportLog.serialize(serializer, report);
                    }
                    if ((testResultHistories = r.getTestResultHistories()) != null) {
                        for (TestResultHistory resultHistory : testResultHistories) {
                            TestResultHistory.serialize(serializer, resultHistory, r.getName());
                        }
                    }
                    serializer.endTag(NS, TEST_TAG);
                }
                serializer.endTag(NS, CASE_TAG);
            }
            serializer.endTag(NS, MODULE_TAG);
        }
        serializer.endDocument();
        ResultHandler.createChecksum(resultDir, result);
        return resultFile;
    }

    public static File createFailureReport(File inputXml) {
        File failureReport = new File(inputXml.getParentFile(), FAILURE_REPORT_NAME);
        try (InputStream xslStream = ResultHandler.class.getResourceAsStream(String.format("/report/%s", FAILURE_XSL_FILE_NAME));
             FileOutputStream outputStream = new FileOutputStream(failureReport);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(inputXml), new StreamResult(outputStream));
        }
        catch (IOException | TransformerException exception) {
            // empty catch block
        }
        return failureReport;
    }

    private static void createChecksum(File resultDir, IInvocationResult invocationResult) {
        RetryChecksumStatus retryStatus = invocationResult.getRetryChecksumStatus();
        switch (retryStatus) {
            case NotRetry: 
            case RetryWithChecksum: {
                ChecksumReporter.tryCreateChecksum(resultDir, invocationResult);
                break;
            }
            case RetryWithoutChecksum: {
                File retryDirectory = invocationResult.getRetryDirectory();
                Path retryChecksum = FileSystems.getDefault().getPath(retryDirectory.getAbsolutePath(), "checksum.data");
                if (!retryChecksum.toFile().exists()) {
                    retryChecksum = FileSystems.getDefault().getPath(retryDirectory.getAbsolutePath(), "checksum.previous.data");
                }
                if (!retryChecksum.toFile().exists()) break;
                File checksumCopy = new File(resultDir, "checksum.previous.data");
                try (FileOutputStream stream = new FileOutputStream(checksumCopy);){
                    Files.copy(retryChecksum, stream);
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static IInvocationResult findResult(File resultsDir, Integer sessionId) {
        return ResultHandler.findResult(resultsDir, sessionId, true);
    }

    private static IInvocationResult findResult(File resultsDir, Integer sessionId, Boolean useChecksum) {
        if (sessionId < 0) {
            throw new IllegalArgumentException(String.format("Invalid session id [%d] ", sessionId));
        }
        File resultDir = ResultHandler.getResultDirectory(resultsDir, sessionId);
        IInvocationResult result = ResultHandler.getResultFromDir(resultDir, useChecksum);
        if (result == null) {
            throw new RuntimeException(String.format("Could not find session [%d]", sessionId));
        }
        return result;
    }

    public static File getResultDirectory(File resultsDir, Integer sessionId) {
        if (sessionId < 0) {
            throw new IllegalArgumentException(String.format("Invalid session id [%d] ", sessionId));
        }
        List<File> allResultDirs = ResultHandler.getResultDirectories(resultsDir);
        if (sessionId >= allResultDirs.size()) {
            throw new IllegalArgumentException(String.format("Invalid session id [%d], results directory (%s) contains only %d results", sessionId, resultsDir.getAbsolutePath(), allResultDirs.size()));
        }
        return allResultDirs.get(sessionId);
    }

    public static List<File> getResultDirectories(File resultsDir) {
        ArrayList<File> directoryList = new ArrayList<File>();
        File[] files = resultsDir.listFiles();
        if (files == null || files.length == 0) {
            return directoryList;
        }
        for (File resultDir : files) {
            File resultFile;
            if (!resultDir.isDirectory() || !(resultFile = new File(resultDir, TEST_RESULT_FILE_NAME)).exists()) continue;
            directoryList.add(resultDir);
        }
        Collections.sort(directoryList, (d1, d2) -> d1.getName().compareTo(d2.getName()));
        return directoryList;
    }

    static String toReadableDateString(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        return dateFormat.format(new Date(time));
    }

    private static String nullToEmpty(String nullable) {
        return nullable == null ? "" : nullable;
    }
}

