/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.targetpreparer;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.TargetSetupError;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@OptionClass(alias="mock-location-preparer")
public class MockLocationPreparer
implements ITargetCleaner {
    private static final String GPS_DATA_TEMP_PATH = "/data/local/tmp/mockgps.data";
    private static final String LOCAL_GPS_DATA_PATH = "/data/mockgps.data";
    private static final String MOCK_LOCATION_APK_PATH = "/apks/AAEMocklocation.apk";
    private static final String MOCK_LOCATION_APP_PKG = "com.google.android.apps.autoembedded.tools.mocklocation";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting Mock Location Setup.");
        try {
            this.pushGPSData(device);
            this.installMockLocationAPK(device);
        }
        catch (IOException ex) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to push resources to the device. Error: %s.", ex.getMessage()));
            throw new TargetSetupError("Unable to push resources to the device.");
        }
        if (!device.isPackageInstalled(MOCK_LOCATION_APP_PKG)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"Mock Location APK is not installed on the device.");
            throw new TargetSetupError("Mock Location APK is not installed on the device.");
        }
        this.enableLocationMocking(device);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Completed Mock Location Setup.");
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting Mock Location Tear Down.");
        this.disableLocationMocking(device);
        this.uninstallMockLocationAPK(device);
        this.deleteMockGPSData(device);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Completed Mock Location Tear Down.");
    }

    private void pushGPSData(ITestDevice device) throws IOException, DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Pushing GPS Data on the device.");
        device.executeAdbCommand(new String[]{"push", this.readGPSDataResource().getPath(), GPS_DATA_TEMP_PATH});
        String currentUserId = device.executeShellCommand("am get-current-user");
        String moveCommand = String.format("mv %s /data/media/%s", GPS_DATA_TEMP_PATH, currentUserId.trim());
        device.executeShellCommand(moveCommand);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Done pushing GPS Data on the device.");
    }

    private File readGPSDataResource() throws IOException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Reading GPS Data from resources.");
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(LOCAL_GPS_DATA_PATH);){
            if (resourceAsStream == null) {
                throw new IllegalArgumentException("Resource not available: /data/mockgps.data");
            }
            File file = this.copyDataFromStreamToFile(resourceAsStream, ".data");
            return file;
        }
    }

    private File copyDataFromStreamToFile(InputStream inputStream, String extension) throws IOException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Started copying data from stream to temporary file.");
        File tempFile = File.createTempFile("tempFile", extension);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int chunkSize;
            byte[] buf = new byte[65536];
            while ((chunkSize = inputStream.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, chunkSize);
            }
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Done copying data from stream to temporary file.");
        return tempFile;
    }

    private void installMockLocationAPK(ITestDevice device) throws IOException, DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Installing Mock Location APK on the device.");
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(MOCK_LOCATION_APK_PATH);){
            if (resourceAsStream == null) {
                throw new IllegalArgumentException("Resource not available: /apks/AAEMocklocation.apk");
            }
            File apkFile = this.copyDataFromStreamToFile(resourceAsStream, ".apk");
            device.installPackage(apkFile, true, true, new String[0]);
            apkFile.delete();
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Done installing Mock Location APK on the device.");
    }

    private void enableLocationMocking(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Start Location Mocking and GPS Service.");
        device.executeShellCommand("content update --uri content://settings/secure --where \"name='mock_location'\" --bind value:i:1");
        device.executeShellCommand("appops set com.google.android.apps.autoembedded.tools.mocklocation android:mock_location allow");
        device.executeShellCommand("settings put secure location_mode 1");
        device.executeShellCommand("am start -a android.intent.action.VIEW -n com.google.android.apps.autoembedded.tools.mocklocation/.LaunchpadActivity");
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Location Mocking and GPS Service started.");
    }

    private void disableLocationMocking(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Disabling GPS Service.");
        device.executeShellCommand("am force-stop com.google.android.apps.autoembedded.tools.mocklocation");
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"GPS Service disabled.");
    }

    private void uninstallMockLocationAPK(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Uninstalling Mock Location APK.");
        device.uninstallPackage(MOCK_LOCATION_APP_PKG);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Mock Location APK uninstalled.");
    }

    private void deleteMockGPSData(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Deleting Mock Location Data.");
        String currentUserId = device.executeShellCommand("am get-current-user");
        String removeCommand = String.format("rm /data/media/%s/mockgps.data", currentUserId.trim());
        device.executeShellCommand(removeCommand);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Mock Location Data deleted.");
    }
}

