/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.targetpreparer;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="set-device-property")
public class SetDevicePropertyPreparer
implements ITargetPreparer {
    @Option(name="set-property", description="Map of properties and values to set and restored")
    private Map<String, String> setPropertyMap = new HashMap<String, String>();
    private static Map<String, String> sharedPropValues = new HashMap<String, String>();
    private final String EMPTY_STRING = "''";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting set property target preparer");
        if (this.setPropertyMap.isEmpty()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"No properties to set. Skipping target preparer");
            return;
        }
        for (Map.Entry<String, String> entry : this.setPropertyMap.entrySet()) {
            sharedPropValues.put(entry.getKey(), device.executeShellCommand(String.format("getprop %s", entry.getKey())).trim());
            device.executeShellCommand(String.format("setprop %s %s", entry.getKey(), entry.getValue()));
        }
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting Device Property teardown - resetting device properties");
        for (Map.Entry<String, String> entry : sharedPropValues.entrySet()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.DEBUG, (String)String.format("Resetting prop %s to %s", entry.getKey(), entry.getValue()));
            if (!entry.getValue().isEmpty()) {
                device.executeShellCommand(String.format("setprop %s %s", entry.getKey(), entry.getValue()));
                continue;
            }
            device.executeShellCommand(String.format("setprop %s %s", entry.getKey(), "''"));
        }
    }
}

