/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.build;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.build.VersionedFile;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CompatibilityBuildHelper {
    public static final String MODULE_IDS = "MODULE_IDS";
    public static final String ROOT_DIR = "ROOT_DIR";
    public static final String SUITE_BUILD = "SUITE_BUILD";
    public static final String SUITE_NAME = "SUITE_NAME";
    public static final String SUITE_FULL_NAME = "SUITE_FULL_NAME";
    public static final String SUITE_VERSION = "SUITE_VERSION";
    public static final String SUITE_PLAN = "SUITE_PLAN";
    public static final String START_TIME_MS = "START_TIME_MS";
    public static final String COMMAND_LINE_ARGS = "command_line_args";
    private static final String ROOT_DIR2 = "ROOT_DIR2";
    private static final String DYNAMIC_CONFIG_OVERRIDE_URL = "DYNAMIC_CONFIG_OVERRIDE_URL";
    private static final String BUSINESS_LOGIC_HOST_FILE = "BUSINESS_LOGIC_HOST_FILE";
    private static final String RETRY_COMMAND_LINE_ARGS = "retry_command_line_args";
    private static final String CONFIG_PATH_PREFIX = "DYNAMIC_CONFIG_FILE:";
    private final IBuildInfo mBuildInfo;

    public CompatibilityBuildHelper(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public IBuildInfo getBuildInfo() {
        return this.mBuildInfo;
    }

    public void setRetryCommandLineArgs(String commandLineArgs) {
        this.mBuildInfo.addBuildAttribute(RETRY_COMMAND_LINE_ARGS, commandLineArgs);
    }

    public String getCommandLineArgs() {
        if (this.mBuildInfo.getBuildAttributes().containsKey(RETRY_COMMAND_LINE_ARGS)) {
            return (String)this.mBuildInfo.getBuildAttributes().get(RETRY_COMMAND_LINE_ARGS);
        }
        return (String)this.mBuildInfo.getBuildAttributes().get(COMMAND_LINE_ARGS);
    }

    public String getRecentCommandLineArgs() {
        return (String)this.mBuildInfo.getBuildAttributes().get(COMMAND_LINE_ARGS);
    }

    public String getSuiteBuild() {
        return (String)this.mBuildInfo.getBuildAttributes().get(SUITE_BUILD);
    }

    public String getSuiteName() {
        return (String)this.mBuildInfo.getBuildAttributes().get(SUITE_NAME);
    }

    public String getSuiteFullName() {
        return (String)this.mBuildInfo.getBuildAttributes().get(SUITE_FULL_NAME);
    }

    public String getSuiteVersion() {
        return (String)this.mBuildInfo.getBuildAttributes().get(SUITE_VERSION);
    }

    public String getSuitePlan() {
        return (String)this.mBuildInfo.getBuildAttributes().get(SUITE_PLAN);
    }

    public String getDynamicConfigUrl() {
        return (String)this.mBuildInfo.getBuildAttributes().get(DYNAMIC_CONFIG_OVERRIDE_URL);
    }

    public long getStartTime() {
        return Long.parseLong((String)this.mBuildInfo.getBuildAttributes().get(START_TIME_MS));
    }

    public void addDynamicConfigFile(String moduleName, File configFile) {
        this.mBuildInfo.setFile(configFile.getName(), configFile, CONFIG_PATH_PREFIX + moduleName);
    }

    public void setBusinessLogicHostFile(File hostFile) {
        this.setBusinessLogicHostFile(hostFile, null);
    }

    public void setBusinessLogicHostFile(File hostFile, String moduleId) {
        String key = moduleId == null ? "" : moduleId;
        this.mBuildInfo.setFile(BUSINESS_LOGIC_HOST_FILE + key, hostFile, hostFile.getName());
    }

    public void setModuleIds(String[] moduleIds) {
        this.mBuildInfo.addBuildAttribute(MODULE_IDS, String.join((CharSequence)",", moduleIds));
    }

    public Map<String, File> getDynamicConfigFiles() {
        HashMap<String, File> configMap = new HashMap<String, File>();
        for (VersionedFile vFile : this.mBuildInfo.getFiles()) {
            if (!vFile.getVersion().startsWith(CONFIG_PATH_PREFIX)) continue;
            configMap.put(vFile.getVersion().substring(CONFIG_PATH_PREFIX.length()), vFile.getFile());
        }
        return configMap;
    }

    public boolean hasBusinessLogicHostFile() {
        return this.hasBusinessLogicHostFile(null);
    }

    public boolean hasBusinessLogicHostFile(String moduleId) {
        String key = moduleId == null ? "" : moduleId;
        return this.mBuildInfo.getFile(BUSINESS_LOGIC_HOST_FILE + key) != null;
    }

    public File getBusinessLogicHostFile() {
        return this.getBusinessLogicHostFile(null);
    }

    public File getBusinessLogicHostFile(String moduleId) {
        String key = moduleId == null ? "" : moduleId;
        return this.mBuildInfo.getFile(BUSINESS_LOGIC_HOST_FILE + key);
    }

    public File getRootDir() throws FileNotFoundException {
        File dir = null;
        if (this.mBuildInfo instanceof IFolderBuildInfo) {
            dir = ((IFolderBuildInfo)this.mBuildInfo).getRootDir();
        }
        if (!(dir != null && dir.exists() || (dir = new File((String)this.mBuildInfo.getBuildAttributes().get(ROOT_DIR))).exists())) {
            dir = new File((String)this.mBuildInfo.getBuildAttributes().get(ROOT_DIR2));
        }
        if (!dir.exists()) {
            throw new FileNotFoundException(String.format("Compatibility root directory %s does not exist", dir.getAbsolutePath()));
        }
        return dir;
    }

    public File getDir() throws FileNotFoundException {
        File dir = new File(this.getRootDir(), String.format("android-%s", this.getSuiteName().toLowerCase()));
        if (!dir.exists()) {
            throw new FileNotFoundException(String.format("Compatibility install folder %s does not exist", dir.getAbsolutePath()));
        }
        return dir;
    }

    public File getResultsDir() throws FileNotFoundException {
        return new File(this.getDir(), "results");
    }

    public File getResultDir() throws FileNotFoundException {
        return new File(this.getResultsDir(), CompatibilityBuildHelper.getDirSuffix(Long.parseLong((String)this.mBuildInfo.getBuildAttributes().get(START_TIME_MS))));
    }

    public File getLogsDir() throws FileNotFoundException {
        return new File(this.getDir(), "logs");
    }

    public File getInvocationLogDir() throws FileNotFoundException {
        return new File(this.getLogsDir(), CompatibilityBuildHelper.getDirSuffix(Long.parseLong((String)this.mBuildInfo.getBuildAttributes().get(START_TIME_MS))));
    }

    public File getSubPlansDir() throws FileNotFoundException {
        File subPlansDir = new File(this.getDir(), "subplans");
        if (!subPlansDir.exists()) {
            subPlansDir.mkdirs();
        }
        return subPlansDir;
    }

    public File getTestsDir() throws FileNotFoundException {
        File testsDir = null;
        try {
            testsDir = new File(this.getDir(), "testcases");
        }
        catch (FileNotFoundException | NullPointerException e) {
            testsDir = null;
        }
        if (testsDir == null && this.mBuildInfo instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mBuildInfo).getTestsDir();
        }
        if (testsDir == null) {
            throw new FileNotFoundException(String.format("No Compatibility tests folder set, did you run lunch?", new Object[0]));
        }
        if (!testsDir.exists()) {
            throw new FileNotFoundException(String.format("Compatibility tests folder %s does not exist", testsDir.getAbsolutePath()));
        }
        return testsDir;
    }

    public File getTestFile(String filename) throws FileNotFoundException {
        return this.getTestFile(filename, null);
    }

    public File getTestFile(String filename, IAbi abi) throws FileNotFoundException {
        File testsDir = this.getTestsDir();
        File testFile = null;
        try {
            testFile = FileUtil.findFile((String)filename, (IAbi)abi, (File[])new File[]{testsDir});
            if (testFile != null) {
                return testFile;
            }
            testFile = this.mBuildInfo.stageRemoteFile(filename, testsDir);
            if (testFile != null && (testFile = FileUtil.findFile((String)filename, (IAbi)abi, (File[])new File[]{testsDir})) != null) {
                return testFile;
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(String.format("Failure in finding compatibility test file %s due to %s", filename, e));
        }
        throw new FileNotFoundException(String.format("Compatibility test file %s does not exist", filename));
    }

    public File getInvocationFailureFile() throws FileNotFoundException {
        return new File(this.getResultDir(), "invocation_failure.txt");
    }

    public File getTestRunsFile() throws FileNotFoundException {
        return new File(this.getResultDir(), "test_runs.txt");
    }

    public static String getDirSuffix(long millis) {
        return new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss").format(new Date(millis));
    }
}

