/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.build;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.build.IDeviceBuildProvider;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.VersionParser;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@OptionClass(alias="compatibility-build-provider")
public class CompatibilityBuildProvider
implements IDeviceBuildProvider,
IInvocationContextReceiver {
    private static final Pattern RELEASE_BUILD = Pattern.compile("^[A-Z]{3}\\d{2}[A-Z]{0,1}$");
    private static final String ROOT_DIR = "ROOT_DIR";
    private static final String SUITE_BUILD = "SUITE_BUILD";
    private static final String SUITE_NAME = "SUITE_NAME";
    private static final String SUITE_FULL_NAME = "SUITE_FULL_NAME";
    private static final String SUITE_VERSION = "SUITE_VERSION";
    private static final String SUITE_PLAN = "SUITE_PLAN";
    private static final String RESULT_DIR = "RESULT_DIR";
    private static final String START_TIME_MS = "START_TIME_MS";
    public static final String DYNAMIC_CONFIG_OVERRIDE_URL = "DYNAMIC_CONFIG_OVERRIDE_URL";
    private static final String API_KEY = "AIzaSyAbwX5JRlmsLeygY2WWihpIJPXFLueOQ3U";
    @Option(name="branch", description="build branch name to supply.")
    private String mBranch = null;
    @Option(name="build-id", description="build version number to supply. Override the default cts version number.")
    private String mBuildId = null;
    @Option(name="build-flavor", description="build flavor name to supply.")
    private String mBuildFlavor = null;
    @Option(name="build-flavor-prefix", description="allow for a prefix to be inserted into build flavor.")
    private String mBuildFlavorPrefix = null;
    @Option(name="build-target", description="build target name to supply.")
    private String mBuildTarget = null;
    @Option(name="build-attribute", description="build attributes to supply.")
    private Map<String, String> mBuildAttributes = new HashMap<String, String>();
    @Option(name="use-device-build-info", description="Bootstrap build info from device")
    private boolean mUseDeviceBuildInfo = false;
    @Option(name="dynamic-config-url", description="Specify the url for override config")
    private String mURL = "https://androidpartner.googleapis.com/v1/dynamicconfig/suites/{suite-name}/modules/{module}/version/{version}?key=AIzaSyAbwX5JRlmsLeygY2WWihpIJPXFLueOQ3U";
    @Option(name="url-suite-name-override", description="Override the name that should used to replace the {suite-name} pattern in the dynamic-config-url.")
    private String mUrlSuiteNameOverride = null;
    @Option(name="plan", description="the test suite plan to run, such as \"everything\" or \"cts\"", importance=Option.Importance.ALWAYS)
    private String mSuitePlan;
    private String mTestTag;
    private File mArtificialRootDir;

    private void injectBuildAttributes(IBuildInfo buildInfo) {
        for (Map.Entry<String, String> entry : this.mBuildAttributes.entrySet()) {
            buildInfo.addBuildAttribute(entry.getKey(), entry.getValue());
        }
        if (this.mTestTag != null) {
            buildInfo.setTestTag(this.mTestTag);
        }
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mTestTag = invocationContext.getTestTag();
    }

    public IBuildInfo getBuild() throws BuildRetrievalError {
        String version = null;
        if (this.mBuildId != null) {
            version = this.mBuildId;
        } else {
            version = this.getSuiteInfoBuildNumber();
            if (version == null) {
                version = "-1";
            }
        }
        DeviceBuildInfo ctsBuild = new DeviceBuildInfo(version, this.mBuildTarget);
        if (this.mBranch != null) {
            ctsBuild.setBuildBranch(this.mBranch);
        }
        if (this.mBuildFlavor != null) {
            String buildFlavor = this.mBuildFlavor;
            if (this.mBuildFlavorPrefix != null) {
                buildFlavor = this.mBuildFlavorPrefix + buildFlavor;
            }
            ctsBuild.setBuildFlavor(buildFlavor);
        }
        this.injectBuildAttributes((IBuildInfo)ctsBuild);
        this.addCompatibilitySuiteInfo((IBuildInfo)ctsBuild);
        return ctsBuild;
    }

    public IBuildInfo getBuild(ITestDevice device) throws BuildRetrievalError, DeviceNotAvailableException {
        String buildFlavor;
        if (!this.mUseDeviceBuildInfo) {
            return this.getBuild();
        }
        if (this.mBuildId == null) {
            this.mBuildId = device.getBuildId();
        }
        if ((buildFlavor = this.mBuildFlavor) == null) {
            buildFlavor = device.getBuildFlavor();
        }
        if (this.mBuildFlavorPrefix != null) {
            buildFlavor = this.mBuildFlavorPrefix + buildFlavor;
        }
        if (this.mBuildTarget == null) {
            String name = device.getProperty("ro.product.name");
            String variant = device.getProperty("ro.build.type");
            this.mBuildTarget = name + "-" + variant;
        }
        DeviceBuildInfo info = new DeviceBuildInfo(this.mBuildId, this.mBuildTarget);
        if (this.mBranch == null) {
            this.mBranch = String.format("%s-%s-%s-%s", device.getProperty("ro.product.brand"), device.getProperty("ro.product.name"), device.getProductVariant(), device.getProperty("ro.build.version.release"));
        }
        info.setBuildBranch(this.mBranch);
        info.setBuildFlavor(buildFlavor);
        String buildAlias = device.getBuildAlias();
        if (RELEASE_BUILD.matcher(buildAlias).matches()) {
            info.addBuildAttribute("build_alias", buildAlias);
        }
        this.injectBuildAttributes((IBuildInfo)info);
        this.addCompatibilitySuiteInfo((IBuildInfo)info);
        return info;
    }

    public void cleanUp(IBuildInfo info) {
        if (info instanceof IDeviceBuildInfo) {
            ArrayList<File> doNotDelete = new ArrayList<File>();
            doNotDelete.add(((IDeviceBuildInfo)info).getTestsDir());
            info.cleanUp(doNotDelete);
        } else {
            info.cleanUp();
        }
        FileUtil.recursiveDelete((File)this.mArtificialRootDir);
    }

    private void addCompatibilitySuiteInfo(IBuildInfo info) {
        long startTimeMs = System.currentTimeMillis();
        info.addBuildAttribute(SUITE_BUILD, this.getSuiteInfoBuildNumber());
        info.addBuildAttribute(SUITE_NAME, this.getSuiteInfoName());
        info.addBuildAttribute(SUITE_FULL_NAME, this.getSuiteInfoFullname());
        info.addBuildAttribute(SUITE_VERSION, this.getSuiteInfoVersion());
        info.addBuildAttribute(SUITE_PLAN, this.mSuitePlan);
        info.addBuildAttribute(START_TIME_MS, Long.toString(startTimeMs));
        info.addBuildAttribute(RESULT_DIR, this.getDirSuffix(startTimeMs));
        String rootDirPath = this.getRootDirPath();
        if (rootDirPath == null || rootDirPath.trim().equals("")) {
            throw new IllegalArgumentException(String.format("Missing install path property %s_ROOT", this.getSuiteInfoName()));
        }
        File rootDir = new File(rootDirPath);
        if (!rootDir.exists()) {
            throw new IllegalArgumentException(String.format("Root directory doesn't exist %s", rootDir.getAbsolutePath()));
        }
        info.addBuildAttribute(ROOT_DIR, rootDir.getAbsolutePath());
        if (info instanceof IDeviceBuildInfo) {
            if (this.mArtificialRootDir == null) {
                info.setProperties(new IBuildInfo.BuildInfoProperties[]{IBuildInfo.BuildInfoProperties.DO_NOT_LINK_TESTS_DIR, IBuildInfo.BuildInfoProperties.DO_NOT_COPY_ON_SHARDING});
            } else {
                info.setProperties(new IBuildInfo.BuildInfoProperties[]{IBuildInfo.BuildInfoProperties.DO_NOT_COPY_ON_SHARDING});
            }
            File testDir = new File(rootDir, String.format("android-%s/testcases/", this.getSuiteInfoName().toLowerCase()));
            ((IDeviceBuildInfo)info).setTestsDir(testDir, "0");
            if (this.getInvocationFiles() != null) {
                this.getInvocationFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, testDir, this.mArtificialRootDir == null);
            }
        }
        if (this.mURL != null && !this.mURL.isEmpty()) {
            String suiteName = this.mUrlSuiteNameOverride;
            if (suiteName == null) {
                suiteName = this.getSuiteInfoName();
            }
            info.addBuildAttribute(DYNAMIC_CONFIG_OVERRIDE_URL, this.mURL.replace("{suite-name}", suiteName));
        }
    }

    String getRootDirPath() {
        String varName = String.format("%s_ROOT", this.getSuiteInfoName().replace('-', '_'));
        String rootDirVariable = System.getProperty(varName);
        if (rootDirVariable != null) {
            return rootDirVariable;
        }
        try {
            this.mArtificialRootDir = FileUtil.createTempDir((String)String.format("%s-root-dir", this.getSuiteInfoName()));
            new File(this.mArtificialRootDir, String.format("android-%s/testcases", this.getSuiteInfoName().toLowerCase())).mkdirs();
            return this.mArtificialRootDir.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("%s was not set, and couldn't create an artificial one.", varName));
        }
    }

    protected String getSuiteInfoName() {
        return TestSuiteInfo.getInstance().getName();
    }

    protected String getSuiteInfoBuildNumber() {
        String buildNumber = TestSuiteInfo.getInstance().getBuildNumber();
        String versionFile = VersionParser.fetchVersion();
        if (versionFile != null) {
            buildNumber = versionFile;
        }
        return buildNumber;
    }

    ExecutionFiles getInvocationFiles() {
        return CurrentInvocation.getInvocationFiles();
    }

    protected String getSuiteInfoFullname() {
        return TestSuiteInfo.getInstance().getFullName();
    }

    protected String getSuiteInfoVersion() {
        return TestSuiteInfo.getInstance().getVersion();
    }

    private String getDirSuffix(long millis) {
        return new SimpleDateFormat("yyyy.MM.dd_HH.mm.ss").format(new Date(millis));
    }
}

