/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TestRunHandler {
    private static final String MAP_DELIMITER = "->";

    public static int getTestRuns(CompatibilityBuildHelper buildHelper, String id) {
        try {
            File f = buildHelper.getTestRunsFile();
            if (!f.exists() || f.length() == 0L) {
                return 1;
            }
            String mapString = FileUtil.readStringFromFile((File)f);
            Map<String, Integer> map = TestRunHandler.stringToMap(mapString);
            Integer testRuns = map.get(id);
            return testRuns == null ? 1 : testRuns;
        }
        catch (IOException e) {
            Object[] objectArray = new Object[1];
            objectArray[0] = CompatibilityBuildHelper.getDirSuffix(buildHelper.getStartTime());
            LogUtil.CLog.e((String)"Could not read test run file for session %s", (Object[])objectArray);
            LogUtil.CLog.e((Throwable)e);
            return 1;
        }
    }

    public static void setTestRuns(CompatibilityBuildHelper buildHelper, Map<String, Integer> testRuns) {
        try {
            File f = buildHelper.getTestRunsFile();
            if (!f.exists()) {
                f.createNewFile();
            }
            FileUtil.writeToFile((String)TestRunHandler.mapToString(testRuns), (File)f);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Exception while writing test runs file.");
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private static String mapToString(Map<String, Integer> map) {
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            sb.append(String.format("%s%s%d\n", entry.getKey(), MAP_DELIMITER, entry.getValue()));
        }
        return sb.toString();
    }

    private static Map<String, Integer> stringToMap(String str) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String entry : str.split("\n")) {
            String[] parts = entry.split(MAP_DELIMITER);
            map.put(parts[0], Integer.parseInt(parts[1]));
        }
        return map;
    }
}

