/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationChecksumHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationResultXml;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.ResultUploader;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.cluster.SubprocessConfigBuilder;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.SnapshotInputStreamSource;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.result.suite.IFormatterGenerator;
import com.android.tradefed.result.suite.XmlFormattedGeneratorReporter;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@OptionClass(alias="result-reporter")
public class CertificationSuiteResultReporter
extends XmlFormattedGeneratorReporter
implements ITestSummaryListener {
    public static final String LATEST_LINK_NAME = "latest";
    public static final String SUMMARY_FILE = "invocation_summary.txt";
    public static final String HTLM_REPORT_NAME = "test_result.html";
    public static final String REPORT_XSL_FILE_NAME = "compatibility_result.xsl";
    public static final String FAILURE_REPORT_NAME = "test_result_failures_suite.html";
    public static final String FAILURE_XSL_FILE_NAME = "compatibility_failures.xsl";
    public static final String BUILD_FINGERPRINT = "build_fingerprint";
    @Option(name="result-server", description="Server to publish test results.")
    private String mResultServer;
    @Option(name="disable-result-posting", description="Disable result posting into report server.")
    private boolean mDisableResultPosting = false;
    @Option(name="include-test-log-tags", description="Include test log tags in report.")
    private boolean mIncludeTestLogTags = false;
    @Option(name="use-log-saver", description="Also saves generated result with log saver")
    private boolean mUseLogSaver = false;
    @Option(name="compress-logs", description="Whether logs will be saved with compression")
    private boolean mCompressLogs = true;
    public static final String INCLUDE_HTML_IN_ZIP = "html-in-zip";
    @Option(name="html-in-zip", description="Whether failure summary report is included in the zip fie.")
    private boolean mIncludeHtml = false;
    @Option(name="result-attribute", description="Extra key-value pairs to be added as attributes and corresponding values of the \"Result\" tag in the result XML.")
    private Map<String, String> mResultAttributes = new HashMap<String, String>();
    @Option(name="cts-on-gsi-variant", description="Workaround for the R release to ensure the CTS-on-GSI report can be parsed by the APFE.")
    private boolean mCtsOnGsiVariant = false;
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;
    private File mLogDir = null;
    private ResultUploader mUploader;
    private LogFileSaver mTestLogSaver;
    private Map<LogFile, InputStreamSource> mPreInvocationLogs = new HashMap<LogFile, InputStreamSource>();
    private ILogSaver mLogSaver;
    private String mReferenceUrl;
    private Map<String, String> mLoggedFiles = new LinkedHashMap<String, String>();
    private static final String[] RESULT_RESOURCES = new String[]{"compatibility_result.css", "compatibility_result.xsl", "logo.png"};

    public final void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        if (this.mBuildHelper == null) {
            this.mBuildHelper = this.createBuildHelper();
        }
        if (this.mResultDir == null) {
            this.initializeResultDirectories();
        }
    }

    CompatibilityBuildHelper createBuildHelper() {
        return new CompatibilityBuildHelper(this.getPrimaryBuildInfo());
    }

    public void testLog(String name, LogDataType type, InputStreamSource stream) {
        if (name.endsWith(".deviceinfo.json")) {
            this.testLogDeviceInfo(name, stream);
            return;
        }
        if (this.mTestLogSaver == null) {
            LogFile info = new LogFile(name, null, type);
            this.mPreInvocationLogs.put(info, (InputStreamSource)new SnapshotInputStreamSource(name, stream.createInputStream()));
            return;
        }
        try {
            File logFile = null;
            if (this.mCompressLogs) {
                try (InputStream inputStream = stream.createInputStream();){
                    logFile = this.mTestLogSaver.saveAndGZipLogData(name, type, inputStream);
                }
            }
            try (InputStream inputStream = stream.createInputStream();){
                logFile = this.mTestLogSaver.saveLogData(name, type, inputStream);
            }
            LogUtil.CLog.d((String)"Saved logs for %s in %s", (Object[])new Object[]{name, logFile.getAbsolutePath()});
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to write log for %s", (Object[])new Object[]{name});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private void testLogDeviceInfo(String name, InputStreamSource stream) {
        try {
            File ediDir = new File(this.mResultDir, "device-info-files");
            ediDir.mkdirs();
            File ediFile = new File(ediDir, name);
            if (!ediFile.exists()) {
                FileUtil.writeToFile((InputStream)stream.createInputStream(), (File)ediFile);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)"Failed to write device info %s to result", (Object[])new Object[]{name});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        if (this.mIncludeTestLogTags) {
            switch (dataType) {
                case BUGREPORT: 
                case LOGCAT: 
                case PNG: {
                    this.mLoggedFiles.put(dataName, logFile.getUrl());
                    break;
                }
            }
        }
    }

    public void putSummary(List<TestSummary> summaries) {
        for (TestSummary summary : summaries) {
            if (this.mReferenceUrl != null || summary.getSummary().getString() == null) continue;
            this.mReferenceUrl = summary.getSummary().getString();
        }
    }

    public void setLogSaver(ILogSaver saver) {
        this.mLogSaver = saver;
    }

    private void initializeResultDirectories() {
        LogUtil.CLog.d((String)"Initializing result directory");
        try {
            this.mResultDir = this.mBuildHelper.getResultDir();
            if (this.mResultDir != null) {
                this.mResultDir.mkdirs();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (this.mResultDir == null) {
            throw new RuntimeException("Result Directory was not created");
        }
        if (!this.mResultDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + this.mResultDir.getAbsolutePath());
        }
        LogUtil.CLog.d((String)"Results Directory: %s", (Object[])new Object[]{this.mResultDir.getAbsolutePath()});
        this.mUploader = new ResultUploader(this.mResultServer, this.mBuildHelper.getSuiteName());
        try {
            this.mLogDir = this.mBuildHelper.getInvocationLogDir();
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        if (this.mLogDir != null && this.mLogDir.mkdirs()) {
            LogUtil.CLog.d((String)"Created log dir %s", (Object[])new Object[]{this.mLogDir.getAbsolutePath()});
        }
        if (this.mLogDir == null || !this.mLogDir.exists()) {
            throw new IllegalArgumentException(String.format("Could not create log dir %s", this.mLogDir.getAbsolutePath()));
        }
        if (this.mTestLogSaver == null) {
            this.mTestLogSaver = new LogFileSaver(this.mLogDir);
            for (LogFile earlyLog : this.mPreInvocationLogs.keySet()) {
                InputStreamSource source = this.mPreInvocationLogs.get(earlyLog);
                try {
                    this.testLog(earlyLog.getPath(), earlyLog.getType(), source);
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
            this.mPreInvocationLogs.clear();
        }
    }

    public IFormatterGenerator createFormatter() {
        return new CertificationResultXml(this.createSuiteName(this.mBuildHelper.getSuiteName()), this.mBuildHelper.getSuiteVersion(), this.createSuiteVariant(), this.mBuildHelper.getSuitePlan(), this.mBuildHelper.getSuiteBuild(), this.mReferenceUrl, this.getLogUrl(), this.mResultAttributes);
    }

    public void preFormattingSetup(IFormatterGenerator formater) {
        super.preFormattingSetup(formater);
        TestSummary summary = this.getSummary();
        try {
            File summaryFile = new File(this.mResultDir, SUMMARY_FILE);
            FileUtil.writeToFile((String)summary.getSummary().toString(), (File)summaryFile);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to save the summary.");
            LogUtil.CLog.e((Throwable)e);
        }
        this.copyDynamicConfigFiles();
        this.copyFormattingFiles(this.mResultDir, this.mBuildHelper.getSuiteName());
    }

    public File createResultDir() throws IOException {
        return this.mResultDir;
    }

    public void postFormattingStep(File resultDir, File reportFile) {
        super.postFormattingStep(resultDir, reportFile);
        this.createChecksum(resultDir, this.getMergedTestRunResults(), (String)this.getPrimaryBuildInfo().getBuildAttributes().get(BUILD_FINGERPRINT));
        File report = null;
        File failureReport = null;
        if (this.mIncludeHtml) {
            report = this.createReport(reportFile);
            failureReport = this.createFailureReport(reportFile);
        }
        File zippedResults = CertificationSuiteResultReporter.zipResults(this.mResultDir);
        if (!this.mIncludeHtml) {
            report = this.createReport(reportFile);
            failureReport = this.createFailureReport(reportFile);
        }
        if (report != null) {
            LogUtil.CLog.i((String)"Viewable report: %s", (Object[])new Object[]{report.getAbsolutePath()});
        }
        try {
            if (failureReport.exists()) {
                LogUtil.CLog.i((String)"Test Result: %s", (Object[])new Object[]{failureReport.getCanonicalPath()});
            } else {
                LogUtil.CLog.i((String)"Test Result: %s", (Object[])new Object[]{reportFile.getCanonicalPath()});
            }
            Path latestLink = this.createLatestLinkDirectory(this.mResultDir.toPath());
            if (latestLink != null) {
                LogUtil.CLog.i((String)("Latest results link: " + latestLink.toAbsolutePath()));
            }
            if ((latestLink = this.createLatestLinkDirectory(this.mLogDir.toPath())) != null) {
                LogUtil.CLog.i((String)("Latest logs link: " + latestLink.toAbsolutePath()));
            }
            this.saveLog(reportFile, zippedResults);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Error when handling the post processing of results file:");
            LogUtil.CLog.e((Throwable)e);
        }
        this.uploadResult(reportFile);
    }

    private String getLogUrl() {
        if (!this.mUseLogSaver || this.mLogSaver == null) {
            return null;
        }
        return this.mLogSaver.getLogReportDir().getUrl();
    }

    private Path createLatestLinkDirectory(Path directory) {
        Path link = null;
        Path parent = directory.getParent();
        if (parent != null) {
            link = parent.resolve(LATEST_LINK_NAME);
            try {
                Files.deleteIfExists(link);
                Files.createSymbolicLink(link, directory, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"Exception while attempting to create 'latest' link to: [%s]", (Object[])new Object[]{directory});
                LogUtil.CLog.e((Throwable)ioe);
                return null;
            }
            catch (UnsupportedOperationException uoe) {
                LogUtil.CLog.e((String)"Failed to create 'latest' symbolic link - unsupported operation");
                return null;
            }
        }
        return link;
    }

    private void copyDynamicConfigFiles() {
        File configDir = new File(this.mResultDir, "config");
        if (!configDir.exists() && !configDir.mkdir()) {
            LogUtil.CLog.w((String)"Failed to make dynamic config directory \"%s\" in the result.", (Object[])new Object[]{configDir.getAbsolutePath()});
        }
        HashSet<String> uniqueModules = new HashSet<String>();
        for (IBuildInfo buildInfo : this.getInvocationContext().getBuildInfos()) {
            CompatibilityBuildHelper helper = new CompatibilityBuildHelper(buildInfo);
            Map<String, File> dcFiles = helper.getDynamicConfigFiles();
            for (String moduleName : dcFiles.keySet()) {
                File srcFile = dcFiles.get(moduleName);
                if (!uniqueModules.contains(moduleName)) {
                    File destFile = new File(configDir, moduleName + ".dynamic");
                    if (destFile.exists()) continue;
                    try {
                        FileUtil.copyFile((File)srcFile, (File)destFile);
                        uniqueModules.add(moduleName);
                    }
                    catch (IOException e) {
                        LogUtil.CLog.w((String)"Failure when copying config file \"%s\" to \"%s\" for module %s", (Object[])new Object[]{srcFile.getAbsolutePath(), destFile.getAbsolutePath(), moduleName});
                        LogUtil.CLog.e((Throwable)e);
                    }
                }
                FileUtil.deleteFile((File)srcFile);
            }
        }
    }

    private void copyFormattingFiles(File resultsDir, String suiteName) {
        for (String resultFileName : RESULT_RESOURCES) {
            InputStream configStream = CertificationResultXml.class.getResourceAsStream(String.format("/report/%s-%s", suiteName, resultFileName));
            if (configStream == null) {
                configStream = CertificationResultXml.class.getResourceAsStream(String.format("/report/%s", resultFileName));
            }
            if (configStream != null) {
                File resultFile = new File(resultsDir, resultFileName);
                try {
                    FileUtil.writeToFile((InputStream)configStream, (File)resultFile);
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Failed to write %s to file", (Object[])new Object[]{resultFileName});
                }
                continue;
            }
            LogUtil.CLog.w((String)"Failed to load %s from jar", (Object[])new Object[]{resultFileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File resultFile, File zippedResults) throws IOException {
        if (!this.mUseLogSaver) {
            return;
        }
        FileInputStream fis = null;
        LogFile logFile = null;
        try {
            fis = new FileInputStream(resultFile);
            logFile = this.mLogSaver.saveLogData("log-result", LogDataType.XML, (InputStream)fis);
            LogUtil.CLog.d((String)"Result XML URL: %s", (Object[])new Object[]{logFile.getUrl()});
            this.logReportFiles(this.getConfiguration(), resultFile, resultFile.getName(), LogDataType.XML);
        }
        catch (IOException ioe) {
            try {
                LogUtil.CLog.e((String)"error saving XML with log saver");
                LogUtil.CLog.e((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.close(fis);
                throw throwable;
            }
            StreamUtil.close((Closeable)fis);
        }
        StreamUtil.close((Closeable)fis);
        if (zippedResults != null) {
            FileInputStream zipResultStream = null;
            try {
                zipResultStream = new FileInputStream(zippedResults);
                logFile = this.mLogSaver.saveLogData("results", LogDataType.ZIP, (InputStream)zipResultStream);
                LogUtil.CLog.d((String)"Result zip URL: %s", (Object[])new Object[]{logFile.getUrl()});
                this.logReportFiles(this.getConfiguration(), zippedResults, "results", LogDataType.ZIP);
            }
            catch (Throwable throwable) {
                StreamUtil.close(zipResultStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)zipResultStream);
        }
    }

    private static File zipResults(File resultsDir) {
        File zipResultFile = null;
        try {
            zipResultFile = new File(resultsDir.getParent(), String.format("%s.zip", resultsDir.getName()));
            ZipUtil.createZip((File)resultsDir, (File)zipResultFile);
        }
        catch (IOException e) {
            LogUtil.CLog.w((String)"Failed to create zip for %s", (Object[])new Object[]{resultsDir.getName()});
        }
        return zipResultFile;
    }

    private void uploadResult(File resultFile) {
        if (this.mResultServer != null && !this.mResultServer.trim().isEmpty() && !this.mDisableResultPosting) {
            try {
                LogUtil.CLog.d((String)"Result Server: %d", (Object[])new Object[]{this.mUploader.uploadResult(resultFile, this.mReferenceUrl)});
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"IOException while uploading result.");
                LogUtil.CLog.e((Throwable)ioe);
            }
        }
    }

    private File createReport(File inputXml) {
        File report = new File(inputXml.getParentFile(), HTLM_REPORT_NAME);
        try (FileInputStream xslStream = new FileInputStream(new File(inputXml.getParentFile(), REPORT_XSL_FILE_NAME));
             FileOutputStream outputStream = new FileOutputStream(report);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(inputXml), new StreamResult(outputStream));
        }
        catch (IOException | TransformerException ignored) {
            LogUtil.CLog.e((Throwable)ignored);
            FileUtil.deleteFile((File)report);
            return null;
        }
        return report;
    }

    private File createFailureReport(File inputXml) {
        File failureReport = new File(inputXml.getParentFile(), FAILURE_REPORT_NAME);
        try (InputStream xslStream = ResultHandler.class.getResourceAsStream(String.format("/report/%s", FAILURE_XSL_FILE_NAME));
             FileOutputStream outputStream = new FileOutputStream(failureReport);){
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xslStream));
            transformer.transform(new StreamSource(inputXml), new StreamResult(outputStream));
        }
        catch (IOException | TransformerException ignored) {
            LogUtil.CLog.e((Throwable)ignored);
        }
        return failureReport;
    }

    private void createChecksum(File resultDir, Collection<TestRunResult> results, String buildFingerprint) {
        CertificationChecksumHelper.tryCreateChecksum(resultDir, results, buildFingerprint);
    }

    private void logReportFiles(IConfiguration configuration, File resultFile, String dataName, LogDataType type) {
        if (configuration == null) {
            return;
        }
        ILogSaver saver = configuration.getLogSaver();
        List listeners = configuration.getTestInvocationListeners();
        try (FileInputStreamSource source = new FileInputStreamSource(resultFile);){
            LogFile loggedFile = null;
            try (InputStream stream = source.createInputStream();){
                loggedFile = saver.saveLogData(dataName, type, stream);
            }
            catch (IOException e) {
                LogUtil.CLog.e((Throwable)e);
            }
            for (ITestInvocationListener listener : listeners) {
                if (listener.equals((Object)this)) continue;
                listener.testLog(dataName, type, (InputStreamSource)source);
                if (loggedFile == null || !(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(dataName, loggedFile);
            }
        }
    }

    private String createSuiteName(String originalSuiteName) {
        String commandLine;
        if (this.mCtsOnGsiVariant && ((commandLine = this.getConfiguration().getCommandLine()).startsWith("cts-on-gsi") || commandLine.startsWith(SubprocessConfigBuilder.createConfigName((String)"cts-on-gsi")))) {
            return "VTS";
        }
        return originalSuiteName;
    }

    private String createSuiteVariant() {
        IConfiguration currentConfig = this.getConfiguration();
        String commandLine = currentConfig.getCommandLine();
        for (SuiteVariant var : SuiteVariant.values()) {
            if (!commandLine.startsWith(var.getConfigName() + " ") && !commandLine.equals(var.getConfigName())) continue;
            return var.getReportDisplayName();
        }
        return null;
    }

    private static enum SuiteVariant {
        CTS_ON_GSI("CTS_ON_GSI", "cts-on-gsi");

        private final String mReportDisplayName;
        private final String mConfigName;

        private SuiteVariant(String reportName, String configName) {
            this.mReportDisplayName = reportName;
            this.mConfigName = configName;
        }

        public String getReportDisplayName() {
            return this.mReportDisplayName;
        }

        public String getConfigName() {
            return this.mConfigName;
        }
    }
}

