/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.TestRecordProto;
import java.io.File;
import java.io.FileNotFoundException;

public class CompatibilityProtoResultReporter
extends FileProtoResultReporter {
    public static final String PROTO_FILE_NAME = "test-record.pb";
    public static final String PROTO_DIR = "proto";
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;

    public void processStartInvocation(TestRecordProto.TestRecord invocationStartRecord, IInvocationContext invocationContext) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)invocationContext.getBuildInfos().get(0));
            this.mResultDir = this.getProtoResultDirectory();
            File protoFile = new File(this.mResultDir, PROTO_FILE_NAME);
            this.setFileOutput(protoFile);
        }
        super.processStartInvocation(invocationStartRecord, invocationContext);
    }

    private File getProtoResultDirectory() {
        File protoDir = null;
        try {
            File resultDir = this.mBuildHelper.getResultDir();
            if (resultDir != null) {
                resultDir.mkdirs();
            }
            protoDir = new File(resultDir, PROTO_DIR);
            protoDir.mkdir();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!protoDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + protoDir.getAbsolutePath());
        }
        LogUtil.CLog.d((String)"Proto Results Directory: %s", (Object[])new Object[]{protoDir.getAbsolutePath()});
        return protoDir;
    }
}

