/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.util.CrashUtils;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.regex.Matcher;
import org.json.JSONArray;

public class CrashReporter
extends BaseTargetPreparer {
    private BackgroundDeviceAction mBackgroundThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upload(ITestDevice device, String testname, JSONArray crashes) {
        if (crashes == null) {
            crashes = new JSONArray();
        }
        try {
            if (testname == null) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"Attempted upload with no test name");
                return;
            }
            device.executeShellCommand(String.format("rm -f %s%s", "/data/local/tmp/CrashParserResults/", "lockFile.loc"));
            Path tmpPath = Files.createTempFile(testname, ".txt", new FileAttribute[0]);
            try {
                Files.setPosixFilePermissions(tmpPath, PosixFilePermissions.fromString("rw-r--r--"));
                File reportFile = tmpPath.toFile();
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(reportFile));){
                    writer.write(crashes.toString());
                }
                device.pushFile(reportFile, "/data/local/tmp/CrashParserResults/" + testname);
            }
            finally {
                Files.deleteIfExists(tmpPath);
            }
            device.executeShellCommand(String.format("touch %s%s", "/data/local/tmp/CrashParserResults/", "lockFile.loc"));
        }
        catch (DeviceNotAvailableException | IOException | RuntimeException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"Upload to device failed");
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp(TestInformation testInfo) {
        ITestDevice device = testInfo.getDevice();
        try {
            device.executeShellCommand("logcat -c");
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"CrashReporterThread failed to clear logcat");
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)e.getMessage());
        }
        try {
            device.executeShellCommand("rm -rf /data/local/tmp/CrashParserResults/");
            device.executeShellCommand("mkdir /data/local/tmp/CrashParserResults/");
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"CrashReporterThread failed to setup storage directory on device");
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)e.getMessage());
            return;
        }
        CrashReporterReceiver receiver = new CrashReporterReceiver(device);
        this.mBackgroundThread = new BackgroundDeviceAction("logcat", "CrashReporter logcat thread", device, (IShellOutputReceiver)receiver, 0);
        this.mBackgroundThread.start();
        try {
            CrashReporterReceiver crashReporterReceiver = receiver;
            synchronized (crashReporterReceiver) {
                ((Object)((Object)receiver)).wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown(TestInformation testInfo, Throwable e) {
        if (this.mBackgroundThread != null) {
            this.mBackgroundThread.cancel();
        }
    }

    private class CrashReporterReceiver
    extends MultiLineReceiver {
        private String mTestName;
        private JSONArray mCrashes;
        private StringBuilder mLogcatChunk = new StringBuilder();
        private ITestDevice mDevice;

        public CrashReporterReceiver(ITestDevice device) {
            this.mDevice = device;
        }

        private void processLogLine(String line) {
            this.mLogcatChunk.append(line);
            this.mLogcatChunk.append('\n');
            Matcher m = CrashUtils.sNewTestPattern.matcher(line);
            if (m.find()) {
                this.mTestName = m.group(1);
                this.mCrashes = new JSONArray();
                this.mLogcatChunk.setLength(0);
            } else if (CrashUtils.sEndofCrashPattern.matcher(line).find()) {
                if (this.mCrashes == null) {
                    return;
                }
                CrashUtils.addAllCrashes((String)this.mLogcatChunk.toString(), (JSONArray)this.mCrashes);
                this.mLogcatChunk.setLength(0);
            } else if (CrashUtils.sUploadRequestPattern.matcher(line).find()) {
                CrashReporter.upload(this.mDevice, this.mTestName, this.mCrashes);
            }
        }

        public synchronized void processNewLines(String[] lines) {
            ((Object)((Object)this)).notifyAll();
            if (!this.isCancelled()) {
                for (String line : lines) {
                    this.processLogLine(line);
                }
            }
        }

        public boolean isCancelled() {
            return CrashReporter.this.mBackgroundThread == null || CrashReporter.this.mBackgroundThread.isCancelled();
        }
    }
}

