/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.SettingsPreparer;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="location-check")
public class LocationCheck
extends SettingsPreparer {
    private static final String LOCATION_SETTING = "location_mode";
    private static final String LOCATION_MODE_ON = "3";
    private static final String GPS_FEATURE = "android.hardware.location.gps";
    private static final String NETWORK_FEATURE = "android.hardware.location.network";

    private boolean hasLocationFeature(ITestDevice device) throws DeviceNotAvailableException {
        String adbFeatures = device.executeShellCommand("pm list features");
        return adbFeatures.contains(GPS_FEATURE) || adbFeatures.contains(NETWORK_FEATURE);
    }

    @Override
    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!this.hasLocationFeature(testInfo.getDevice())) {
            return;
        }
        LogUtil.CLog.i((String)"Verifying location setting");
        this.mSettingName = LOCATION_SETTING;
        this.mSettingType = SettingsPreparer.SettingType.SECURE;
        this.mExpectedSettingValues.add(LOCATION_MODE_ON);
        this.mFailureMessage = "Location services must be enabled in order to successfully run the test suite";
        super.run(testInfo);
    }
}

