/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.DynamicConfigFileReader;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParserException;

@OptionClass(alias="media-preparer")
public class MediaPreparer
extends BaseTargetPreparer {
    @Option(name="local-media-path", description="Absolute path of the media files directory, containing'bbb_short' and 'bbb_full' directories")
    private String mLocalMediaPath = null;
    @Option(name="skip-media-download", description="Whether to skip the media files precondition")
    private boolean mSkipMediaDownload = false;
    @Deprecated
    @Option(name="media-download-only", description="Deprecated: Only download media files; do not run instrumentation or copy files")
    private boolean mMediaDownloadOnly = false;
    @Option(name="images-only", description="Only push images files to the device")
    private boolean mImagesOnly = false;
    @Option(name="push-all", description="Push everything downloaded to the device, use 'media-folder-name' to specify the destination dir name.")
    private boolean mPushAll = false;
    @Option(name="dynamic-config-module", description="For a target preparer, the 'module' of the configuration is the test suite.")
    private String mDynamicConfigModule = "cts";
    @Option(name="media-folder-name", description="The name of local directory into which media files will be downloaded, if option 'local-media-path' is not provided. This directory will live inside the temp directory. If option 'push-all' is set, this is also the subdirectory name on device where media files are pushed to")
    private String mMediaFolderName = "android-cts-media";
    protected String mBaseDeviceModuleDir;
    protected String mBaseDeviceShortDir;
    protected String mBaseDeviceFullDir;
    protected String mBaseDeviceImagesDir;
    protected Resolution mMaxRes = null;
    protected String mFailureStackTrace = null;
    protected static final String MEDIA_FOLDER_NAME = "android-cts-media";
    private static final String MEDIA_FILES_URL_KEY = "media_files_url";
    private static final String APP_APK = "CtsMediaPreparerApp.apk";
    private static final String APP_PKG_NAME = "android.mediastress.cts.preconditions.app";
    private static final String RESOLUTION_STRING_KEY = "resolution";
    private static final String LOG_TAG = "MediaPreparer";
    protected static final Resolution DEFAULT_MAX_RESOLUTION = new Resolution(480, 360);
    protected static final Resolution[] RESOLUTIONS = new Resolution[]{new Resolution(176, 144), new Resolution(480, 360), new Resolution(720, 480), new Resolution(1280, 720), new Resolution(1920, 1080)};

    public static File getDefaultMediaDir() {
        return new File(System.getProperty("java.io.tmpdir"), MEDIA_FOLDER_NAME);
    }

    protected File getMediaDir() {
        return new File(System.getProperty("java.io.tmpdir"), this.mMediaFolderName);
    }

    protected boolean mediaFilesExistOnDevice(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mPushAll) {
            return device.doesFileExist(this.mBaseDeviceModuleDir);
        }
        if (!this.mImagesOnly) {
            for (Resolution resolution : RESOLUTIONS) {
                if (resolution.width > this.mMaxRes.width) break;
                String deviceShortFilePath = this.mBaseDeviceShortDir + resolution.toString();
                String deviceFullFilePath = this.mBaseDeviceFullDir + resolution.toString();
                if (device.doesFileExist(deviceShortFilePath) && device.doesFileExist(deviceFullFilePath)) continue;
                return false;
            }
        }
        return device.doesFileExist(this.mBaseDeviceImagesDir);
    }

    private void updateLocalMediaPath(ITestDevice device, File mediaFolder) throws TargetSetupError {
        String[] subDirs = mediaFolder.list();
        if (subDirs.length != 1) {
            throw new TargetSetupError(String.format("Unexpected contents in directory %s", mediaFolder.getAbsolutePath()), device.getDeviceDescriptor());
        }
        this.mLocalMediaPath = new File(mediaFolder, subDirs[0]).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadMediaToHost(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError {
        Class<MediaPreparer> clazz = MediaPreparer.class;
        synchronized (MediaPreparer.class) {
            URL url;
            File mediaFolder = this.getMediaDir();
            if (mediaFolder.exists() && mediaFolder.list().length > 0) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return mediaFolder;
            }
            mediaFolder.mkdirs();
            try {
                String mediaUrlString = DynamicConfigFileReader.getValueFromConfig(buildInfo, this.mDynamicConfigModule, MEDIA_FILES_URL_KEY);
                url = new URL(mediaUrlString);
            }
            catch (IOException | XmlPullParserException e) {
                throw new TargetSetupError("Trouble finding media file download location with dynamic configuration", e, device.getDeviceDescriptor());
            }
            File mediaFolderZip = new File(mediaFolder.getAbsolutePath() + ".zip");
            try {
                LogUtil.printLog((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)String.format("Downloading media files from %s", url.toString()));
                URLConnection conn = url.openConnection();
                InputStream in = conn.getInputStream();
                mediaFolderZip.createNewFile();
                FileUtil.writeToFile((InputStream)in, (File)mediaFolderZip);
                LogUtil.printLog((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)"Unzipping media files");
                ZipUtil.extractZip((ZipFile)new ZipFile(mediaFolderZip), (File)mediaFolder);
            }
            catch (IOException e) {
                FileUtil.recursiveDelete((File)mediaFolder);
                throw new TargetSetupError(String.format("Failed to download and open media files on host machine at '%s'. These media files are required for compatibility tests.", mediaFolderZip), (Throwable)e, device.getDeviceDescriptor(), false);
            }
            finally {
                FileUtil.deleteFile((File)mediaFolderZip);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mediaFolder;
        }
    }

    protected void copyMediaFiles(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mPushAll) {
            this.copyAll(device);
            return;
        }
        if (!this.mImagesOnly) {
            this.copyVideoFiles(device);
        }
        this.copyImagesFiles(device);
    }

    protected void copyVideoFiles(ITestDevice device) throws DeviceNotAvailableException {
        for (Resolution resolution : RESOLUTIONS) {
            if (resolution.width > this.mMaxRes.width) {
                LogUtil.CLog.i((String)"Media file copying complete");
                return;
            }
            String deviceShortFilePath = this.mBaseDeviceShortDir + resolution.toString();
            String deviceFullFilePath = this.mBaseDeviceFullDir + resolution.toString();
            if (device.doesFileExist(deviceShortFilePath) && device.doesFileExist(deviceFullFilePath)) continue;
            LogUtil.CLog.i((String)"Copying files of resolution %s to device", (Object[])new Object[]{resolution.toString()});
            String localShortDirName = "bbb_short/" + resolution.toString();
            String localFullDirName = "bbb_full/" + resolution.toString();
            File localShortDir = new File(this.mLocalMediaPath, localShortDirName);
            File localFullDir = new File(this.mLocalMediaPath, localFullDirName);
            if (!device.doesFileExist(deviceShortFilePath)) {
                device.pushDir(localShortDir, deviceShortFilePath);
            }
            if (device.doesFileExist(deviceFullFilePath)) continue;
            device.pushDir(localFullDir, deviceFullFilePath);
        }
    }

    protected void copyImagesFiles(ITestDevice device) throws DeviceNotAvailableException {
        if (!device.doesFileExist(this.mBaseDeviceImagesDir)) {
            LogUtil.CLog.i((String)"Copying images files to device");
            device.pushDir(new File(this.mLocalMediaPath, "images"), this.mBaseDeviceImagesDir);
        }
    }

    protected void copyAll(ITestDevice device) throws DeviceNotAvailableException {
        if (!device.doesFileExist(this.mBaseDeviceModuleDir)) {
            LogUtil.CLog.i((String)"Copying files to device");
            device.pushDir(new File(this.mLocalMediaPath), this.mBaseDeviceModuleDir);
        }
    }

    protected void setMountPoint(ITestDevice device) {
        String mountPoint = device.getMountPoint("EXTERNAL_STORAGE");
        this.mBaseDeviceModuleDir = String.format("%s/test/%s/", mountPoint, this.mMediaFolderName);
        this.mBaseDeviceShortDir = String.format("%s/test/bbb_short/", mountPoint);
        this.mBaseDeviceFullDir = String.format("%s/test/bbb_full/", mountPoint);
        this.mBaseDeviceImagesDir = String.format("%s/test/images/", mountPoint);
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        if (this.mImagesOnly && this.mPushAll) {
            throw new TargetSetupError("'images-only' and 'push-all' cannot be set to true together.", device.getDeviceDescriptor());
        }
        if (this.mSkipMediaDownload) {
            LogUtil.CLog.i((String)"Skipping media preparation");
            return;
        }
        this.setMountPoint(device);
        if (!this.mImagesOnly && !this.mPushAll) {
            this.setMaxRes(testInfo);
        }
        if (this.mediaFilesExistOnDevice(device)) {
            LogUtil.CLog.i((String)"Media files found on the device");
            return;
        }
        if (this.mLocalMediaPath == null) {
            File mediaFolder = this.downloadMediaToHost(device, buildInfo);
            this.updateLocalMediaPath(device, mediaFolder);
        }
        LogUtil.CLog.i((String)"Media files located on host at: %s", (Object[])new Object[]{this.mLocalMediaPath});
        this.copyMediaFiles(device);
    }

    private void setMaxRes(TestInformation testInfo) throws DeviceNotAvailableException {
        MediaPreparerListener listener = new MediaPreparerListener();
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        File apkFile = null;
        try {
            apkFile = buildHelper.getTestFile(APP_APK);
            if (!apkFile.exists()) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            this.mMaxRes = DEFAULT_MAX_RESOLUTION;
            LogUtil.CLog.w((String)"Cound not find %s to determine maximum resolution, copying up to %s", (Object[])new Object[]{APP_APK, DEFAULT_MAX_RESOLUTION.toString()});
            return;
        }
        if (device.getAppPackageInfo(APP_PKG_NAME) != null) {
            device.uninstallPackage(APP_PKG_NAME);
        }
        LogUtil.CLog.i((String)"Instrumenting package %s:", (Object[])new Object[]{APP_PKG_NAME});
        AndroidJUnitTest instrTest = new AndroidJUnitTest();
        instrTest.setDevice(device);
        instrTest.setInstallFile(apkFile);
        instrTest.setPackageName(APP_PKG_NAME);
        instrTest.setConfiguration((IConfiguration)new Configuration("stub", "stub"));
        instrTest.run(testInfo, (ITestInvocationListener)listener);
        if (this.mFailureStackTrace != null) {
            this.mMaxRes = DEFAULT_MAX_RESOLUTION;
            LogUtil.CLog.w((String)"Retrieving maximum resolution failed with trace:\n%s", (Object[])new Object[]{this.mFailureStackTrace});
            LogUtil.CLog.w((String)"Copying up to %s", (Object[])new Object[]{DEFAULT_MAX_RESOLUTION.toString()});
        } else if (this.mMaxRes == null) {
            this.mMaxRes = DEFAULT_MAX_RESOLUTION;
            LogUtil.CLog.w((String)"Failed to pull resolution capabilities from device, copying up to %s", (Object[])new Object[]{DEFAULT_MAX_RESOLUTION.toString()});
        }
    }

    private class MediaPreparerListener
    implements ITestInvocationListener {
        private MediaPreparerListener() {
        }

        public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> metrics) {
            MetricMeasurement.Metric resMetric = metrics.get(MediaPreparer.RESOLUTION_STRING_KEY);
            if (resMetric != null) {
                MediaPreparer.this.mMaxRes = new Resolution(resMetric.getMeasurements().getSingleString());
            }
        }

        public void testFailed(TestDescription test, String trace) {
            MediaPreparer.this.mFailureStackTrace = trace;
        }
    }

    protected static final class Resolution {
        private static final String PATTERN = "(\\d+)x(\\d+)";
        private static final int WIDTH_INDEX = 1;
        private static final int HEIGHT_INDEX = 2;
        private final int width;
        private final int height;

        private Resolution(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private Resolution(String resolution) {
            Pattern pattern = Pattern.compile(PATTERN);
            Matcher matcher = pattern.matcher(resolution);
            matcher.find();
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }

        public String toString() {
            return String.format("%dx%d", this.width, this.height);
        }

        public int getWidth() {
            return this.width;
        }
    }
}

