/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.ArrayList;
import java.util.List;

public abstract class PreconditionPreparer
extends BaseTargetPreparer {
    public static final String SKIP_PRECONDITIONS_OPTION = "skip-preconditions";
    public static final String PRECONDITION_ARG_OPTION = "precondition-arg";
    @Option(name="skip-preconditions", shortName=111, description="Whether preconditions should be skipped")
    private boolean mSkipPreconditions = false;
    @Option(name="precondition-arg", description="the arguments to pass to a precondition. The expected format is\"<arg-name>:<arg-value>\"")
    private List<String> mPreconditionArgs = new ArrayList<String>();
    protected final String mLogTag = ((Object)((Object)this)).getClass().getSimpleName();

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mSkipPreconditions) {
            return;
        }
        for (String preconditionArg : this.mPreconditionArgs) {
            String[] parts = preconditionArg.split(":");
            String argName = parts[0];
            String argValue = parts.length > 1 ? parts[1] : Boolean.toString(true);
            this.setOption(argName, argValue);
        }
        this.run(testInfo);
    }

    private void setOption(String option, String value) {
        try {
            OptionSetter setter = new OptionSetter(new Object[]{this});
            setter.setOptionValue(option, value);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.i((String)"Value %s for option %s not applicable for class %s", (Object[])new Object[]{value, option, ((Object)((Object)this)).getClass().getName()});
        }
    }

    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.run(testInfo.getDevice(), testInfo.getBuildInfo());
    }

    @Deprecated
    public void run(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    @Deprecated
    protected void logInfo(String info) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.INFO, (String)this.mLogTag, (String)info);
    }

    @Deprecated
    protected void logInfo(String infoFormat, Object ... args) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.INFO, (String)this.mLogTag, (String)String.format(infoFormat, args));
    }

    @Deprecated
    protected void logWarning(String warning) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.WARN, (String)this.mLogTag, (String)warning);
    }

    @Deprecated
    protected void logWarning(String warningFormat, Object ... args) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.WARN, (String)this.mLogTag, (String)String.format(warningFormat, args));
    }

    @Deprecated
    protected void logError(String error) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.ERROR, (String)this.mLogTag, (String)error);
    }

    @Deprecated
    protected void logError(String errorFormat, Object ... args) {
        LogUtil.printLog((Log.LogLevel)Log.LogLevel.ERROR, (String)this.mLogTag, (String)String.format(errorFormat, args));
    }

    @Deprecated
    protected void logError(Throwable t) {
        if (t != null) {
            Log.e((String)this.mLogTag, (Throwable)t);
        }
    }
}

