/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;

@OptionClass(alias="property-check")
public class PropertyCheck
extends PreconditionPreparer {
    @Option(name="property-name", description="The name of the property to check", mandatory=true)
    private String mPropertyName = null;
    @Option(name="expected-value", description="The expected value of the property")
    private String mExpectedPropertyValue = null;
    @Option(name="is-set-only", description="Whether this value must be set only (don't check value)")
    private boolean mPropertyValueIsSetOnly = false;
    @Option(name="throw-error", description="Whether to throw an error for an unexpected property value")
    private boolean mThrowError = false;

    @Override
    public void run(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        String propertyValue = device.getProperty(this.mPropertyName);
        if (this.mPropertyValueIsSetOnly && this.mExpectedPropertyValue != null) {
            throw new IllegalArgumentException("is-set-only and expected-value cannot both be set.");
        }
        if (!this.mPropertyValueIsSetOnly && this.mExpectedPropertyValue == null) {
            throw new IllegalArgumentException("is-set-only or expected-value must be set.");
        }
        if (this.mPropertyValueIsSetOnly) {
            if (propertyValue == null || propertyValue.equals("")) {
                String msg = String.format("Property \"%s\" not found or not set on device", this.mPropertyName);
                if (this.mThrowError) {
                    throw new TargetSetupError(msg, device.getDeviceDescriptor());
                }
                this.logWarning(msg);
            }
            return;
        }
        if (propertyValue == null) {
            LogUtil.CLog.w((String)"Property \"%s\" not found on device, cannot verify value \"%s\" ", (Object[])new Object[]{this.mPropertyName, this.mExpectedPropertyValue});
            return;
        }
        if (!this.mExpectedPropertyValue.equalsIgnoreCase(propertyValue)) {
            String msg = String.format("Expected \"%s\" but found \"%s\" for property: %s", this.mExpectedPropertyValue, propertyValue, this.mPropertyName);
            if (this.mThrowError) {
                throw new TargetSetupError(msg, device.getDeviceDescriptor());
            }
            LogUtil.CLog.w((String)msg);
        }
    }
}

