/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.HostTest;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.HashMap;
import java.util.Map;

public class JarHostTest
extends HostTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.setTestInformation(testInfo);
        int numTests = 0;
        RuntimeException bufferedException = null;
        try {
            numTests = this.countTestCases();
        }
        catch (RuntimeException e) {
            bufferedException = e;
        }
        long startTime = System.currentTimeMillis();
        listener.testRunStarted(((Object)((Object)this)).getClass().getName(), numTests);
        HostTestListener hostListener = new HostTestListener(listener);
        try {
            if (bufferedException != null) {
                throw bufferedException;
            }
            super.run(testInfo, (ITestInvocationListener)hostListener);
        }
        finally {
            HashMap<String, MetricMeasurement.Metric> metrics = hostListener.getNewMetrics();
            metrics.putAll(TfMetricProtoUtil.upgradeConvert(hostListener.getMetrics()));
            listener.testRunEnded(System.currentTimeMillis() - startTime, metrics);
        }
    }

    public class HostTestListener
    extends ResultForwarder {
        private Map<String, String> mCollectedMetrics;
        private HashMap<String, MetricMeasurement.Metric> mCollectedNewMetrics;

        public HostTestListener(ITestInvocationListener listener) {
            super(new ITestInvocationListener[]{listener});
            this.mCollectedMetrics = new HashMap<String, String>();
            this.mCollectedNewMetrics = new HashMap();
        }

        public void testRunStarted(String name, int numTests) {
            LogUtil.CLog.d((String)"HostTestListener.testRunStarted(%s, %d)", (Object[])new Object[]{name, numTests});
        }

        public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
            LogUtil.CLog.d((String)"HostTestListener.testRunEnded(%d, %s)", (Object[])new Object[]{elapsedTime, metrics.toString()});
            this.mCollectedMetrics.putAll(metrics);
        }

        public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
            LogUtil.CLog.d((String)"HostTestListener.testRunEnded(%d, %s)", (Object[])new Object[]{elapsedTime, metrics.toString()});
            this.mCollectedNewMetrics.putAll(metrics);
        }

        Map<String, String> getMetrics() {
            return this.mCollectedMetrics;
        }

        HashMap<String, MetricMeasurement.Metric> getNewMetrics() {
            return this.mCollectedNewMetrics;
        }
    }
}

