/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.result.ModuleListener;
import com.android.compatibility.common.tradefed.targetprep.DynamicConfigPusher;
import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.compatibility.common.tradefed.targetprep.TokenRequirement;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.AbiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Deprecated
public class ModuleDef
implements IModuleDef {
    private final String mId;
    private final String mName;
    private final IAbi mAbi;
    private final Set<String> mTokens = new HashSet<String>();
    private IRemoteTest mTest = null;
    private List<ITargetPreparer> mDynamicConfigPreparers = new ArrayList<ITargetPreparer>();
    private List<ITargetPreparer> mPreconditions = new ArrayList<ITargetPreparer>();
    private List<ITargetPreparer> mPreparers = new ArrayList<ITargetPreparer>();
    private List<ITargetCleaner> mCleaners = new ArrayList<ITargetCleaner>();
    private IBuildInfo mBuild;
    private ITestDevice mDevice;
    private Set<String> mPreparerWhitelist = new HashSet<String>();
    private ConfigurationDescriptor mConfigurationDescriptor;
    private IInvocationContext mContext;

    public ModuleDef(String name, IAbi abi, IRemoteTest test, List<ITargetPreparer> preparers, ConfigurationDescriptor configurationDescriptor) {
        this.mId = AbiUtils.createId((String)abi.getName(), (String)name);
        this.mName = name;
        this.mAbi = abi;
        this.mTest = test;
        this.mConfigurationDescriptor = configurationDescriptor;
        this.initializePrepareLists(preparers);
    }

    protected void initializePrepareLists(List<ITargetPreparer> preparers) throws IllegalArgumentException {
        boolean hasAbiReceiver = false;
        for (ITargetPreparer preparer : preparers) {
            if (preparer instanceof IAbiReceiver) {
                hasAbiReceiver = true;
            }
            if (preparer instanceof PreconditionPreparer) {
                this.mPreconditions.add(preparer);
            } else if (preparer instanceof DynamicConfigPusher) {
                this.mDynamicConfigPreparers.add(preparer);
            } else if (preparer instanceof TokenRequirement) {
                this.mTokens.addAll(((TokenRequirement)preparer).getTokens());
            } else {
                this.mPreparers.add(preparer);
            }
            if (!(preparer instanceof ITargetCleaner)) continue;
            this.mCleaners.add((ITargetCleaner)preparer);
        }
        Collections.reverse(this.mCleaners);
        this.checkRequiredInterfaces(hasAbiReceiver);
    }

    protected void checkRequiredInterfaces(boolean hasAbiReceiver) throws IllegalArgumentException {
        if (!hasAbiReceiver && !(this.mTest instanceof IAbiReceiver)) {
            throw new IllegalArgumentException(this.mTest + "does not implement IAbiReceiver - for multi-abi testing (64bit)");
        }
        if (!(this.mTest instanceof IRuntimeHintProvider)) {
            throw new IllegalArgumentException(this.mTest + " does not implement IRuntimeHintProvider - to provide estimates of test invocation time");
        }
        if (!(this.mTest instanceof ITestCollector)) {
            throw new IllegalArgumentException(this.mTest + " does not implement ITestCollector - for test list collection");
        }
        if (!(this.mTest instanceof ITestFilterReceiver)) {
            throw new IllegalArgumentException(this.mTest + " does not implement ITestFilterReceiver - to allow tests to be filtered");
        }
    }

    public String toString() {
        return this.mId;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    protected Set<String> getPreparerWhitelist() {
        return this.mPreparerWhitelist;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    @Override
    public Set<String> getTokens() {
        return this.mTokens;
    }

    public long getRuntimeHint() {
        if (this.mTest instanceof IRuntimeHintProvider) {
            return ((IRuntimeHintProvider)this.mTest).getRuntimeHint();
        }
        return TimeUnit.MINUTES.toMillis(1L);
    }

    @Override
    public IRemoteTest getTest() {
        return this.mTest;
    }

    @Override
    public void setPreparerWhitelist(Set<String> preparerWhitelist) {
        this.mPreparerWhitelist.addAll(preparerWhitelist);
    }

    @Override
    public int compareTo(IModuleDef moduleDef) {
        return this.getName().compareTo(moduleDef.getName());
    }

    public void setBuild(IBuildInfo build) {
        this.mBuild = build;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        LogUtil.CLog.d((String)"Running module %s", (Object[])new Object[]{this.toString()});
        this.runPreparerSetups();
        LogUtil.CLog.d((String)"Test: %s", (Object[])new Object[]{this.mTest.getClass().getSimpleName()});
        this.prepareTestClass();
        ModuleListener moduleListener = new ModuleListener(this, listener);
        ModuleFinisher moduleFinisher = new ModuleFinisher(moduleListener);
        this.mTest.run((ITestInvocationListener)moduleFinisher);
        moduleFinisher.finish();
        this.runPreparerTeardowns();
    }

    protected void runPreparerTeardowns() throws DeviceNotAvailableException {
        for (ITargetCleaner cleaner : this.mCleaners) {
            LogUtil.CLog.d((String)"Cleaner: %s", (Object[])new Object[]{cleaner.getClass().getSimpleName()});
            cleaner.tearDown(this.mDevice, this.mBuild, null);
        }
    }

    protected void runPreparerSetups() throws DeviceNotAvailableException {
        for (ITargetPreparer preparer : this.mDynamicConfigPreparers) {
            this.runPreparerSetup(preparer);
        }
        for (ITargetPreparer preparer : this.mPreparers) {
            this.runPreparerSetup(preparer);
        }
    }

    protected void prepareTestClass() {
        if (this.mTest instanceof IAbiReceiver) {
            ((IAbiReceiver)this.mTest).setAbi(this.mAbi);
        }
        if (this.mTest instanceof IBuildReceiver) {
            ((IBuildReceiver)this.mTest).setBuild(this.mBuild);
        }
        if (this.mTest instanceof IDeviceTest) {
            ((IDeviceTest)this.mTest).setDevice(this.mDevice);
        }
        if (this.mTest instanceof IInvocationContextReceiver) {
            ((IInvocationContextReceiver)this.mTest).setInvocationContext(this.mContext);
        }
    }

    @Override
    public boolean prepare(boolean skipPrep, List<String> preconditionArgs) throws DeviceNotAvailableException {
        for (ITargetPreparer preparer : this.mDynamicConfigPreparers) {
            this.runPreparerSetup(preparer);
        }
        for (ITargetPreparer preparer : this.mPreconditions) {
            this.setOption(preparer, "skip-preconditions", Boolean.toString(skipPrep));
            for (String preconditionArg : preconditionArgs) {
                this.setOption(preparer, "precondition-arg", preconditionArg);
            }
            try {
                this.runPreparerSetup(preparer);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e((String)"Precondition class %s failed", (Object[])new Object[]{preparer.getClass().getCanonicalName()});
                return false;
            }
        }
        return true;
    }

    private void runPreparerSetup(ITargetPreparer preparer) throws DeviceNotAvailableException {
        String preparerName = preparer.getClass().getCanonicalName();
        if (!this.mPreparerWhitelist.isEmpty() && !this.mPreparerWhitelist.contains(preparerName)) {
            LogUtil.CLog.d((String)"Skipping Preparer: %s since it is not in the whitelist %s", (Object[])new Object[]{preparerName, this.mPreparerWhitelist});
            return;
        }
        LogUtil.CLog.d((String)"Preparer: %s", (Object[])new Object[]{preparer.getClass().getSimpleName()});
        if (preparer instanceof IAbiReceiver) {
            ((IAbiReceiver)preparer).setAbi(this.mAbi);
        }
        try {
            preparer.setUp(this.mDevice, this.mBuild);
        }
        catch (BuildError e) {
            LogUtil.CLog.e((String)"Unexpected BuildError from preparer: %s", (Object[])new Object[]{preparer.getClass().getCanonicalName()});
            throw new RuntimeException(e);
        }
        catch (TargetSetupError e) {
            LogUtil.CLog.e((String)"TargetSetupError in preparer: %s", (Object[])new Object[]{preparer.getClass().getCanonicalName()});
            throw new RuntimeException(e);
        }
    }

    private void setOption(Object target, String option, String value) {
        try {
            OptionSetter setter = new OptionSetter(new Object[]{target});
            setter.setOptionValue(option, value);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }

    public void setCollectTestsOnly(boolean collectTestsOnly) {
        ((ITestCollector)this.mTest).setCollectTestsOnly(collectTestsOnly);
    }

    @Override
    public ConfigurationDescriptor getConfigurationDescriptor() {
        return this.mConfigurationDescriptor;
    }

    protected IInvocationContext getInvocationContext() {
        return this.mContext;
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mContext = invocationContext;
    }

    private class ModuleFinisher
    extends ResultForwarder {
        private boolean mFinished;
        private ITestInvocationListener mListener;

        public ModuleFinisher(ITestInvocationListener listener) {
            super(new ITestInvocationListener[]{listener});
            this.mListener = listener;
            this.mFinished = false;
        }

        public void testRunStarted(String name, int numTests) {
            this.mListener.testRunStarted(name, numTests);
            this.mFinished = true;
        }

        public void finish() {
            if (!this.mFinished) {
                this.mListener.testRunStarted(ModuleDef.this.mId, 0);
                this.mListener.testRunEnded(0L, new HashMap());
            }
        }
    }
}

