/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.TestRunHandler;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.compatibility.common.tradefed.testtype.IModuleRepo;
import com.android.compatibility.common.tradefed.testtype.ModuleDef;
import com.android.compatibility.common.tradefed.util.LinearPartition;
import com.android.compatibility.common.tradefed.util.UniqueModuleCountUtil;
import com.android.compatibility.common.util.TestFilter;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.TimeUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class ModuleRepo
implements IModuleRepo {
    private static final String CONFIG_EXT = ".config";
    private static final Map<String, Integer> ENDING_MODULES = new HashMap<String, Integer>();
    private int mInitCount = 0;
    private Set<IModuleDef> mTokenModuleScheduled;
    private static Object lock;
    private int mTotalShards;
    private Integer mShardIndex;
    private Map<String, Set<String>> mDeviceTokens = new HashMap<String, Set<String>>();
    private Map<String, Map<String, List<String>>> mTestArgs = new HashMap<String, Map<String, List<String>>>();
    private Map<String, Map<String, List<String>>> mModuleArgs = new HashMap<String, Map<String, List<String>>>();
    private boolean mIncludeAll;
    private Map<String, List<TestFilter>> mIncludeFilters = new HashMap<String, List<TestFilter>>();
    private Map<String, List<TestFilter>> mExcludeFilters = new HashMap<String, List<TestFilter>>();
    private IConfigurationFactory mConfigFactory = ConfigurationFactory.getInstance();
    private volatile boolean mInitialized = false;
    private List<IModuleDef> mTokenModules = new ArrayList<IModuleDef>();
    private List<IModuleDef> mNonTokenModules = new ArrayList<IModuleDef>();

    @Override
    public int getNumberOfShards() {
        return this.mTotalShards;
    }

    protected Map<String, Set<String>> getDeviceTokens() {
        return this.mDeviceTokens;
    }

    @Override
    public List<IModuleDef> getNonTokenModules() {
        return this.mNonTokenModules;
    }

    @Override
    public List<IModuleDef> getTokenModules() {
        return this.mTokenModules;
    }

    @Override
    public String[] getModuleIds() {
        HashSet<String> moduleIdSet = new HashSet<String>();
        for (IModuleDef moduleDef : this.mNonTokenModules) {
            moduleIdSet.add(moduleDef.getId());
        }
        for (IModuleDef moduleDef : this.mTokenModules) {
            moduleIdSet.add(moduleDef.getId());
        }
        return moduleIdSet.toArray(new String[moduleIdSet.size()]);
    }

    @Override
    public boolean isInitialized() {
        return this.mInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(int totalShards, Integer shardIndex, File testsDir, Set<IAbi> abis, List<String> deviceTokens, List<String> testArgs, List<String> moduleArgs, Set<String> includeFilters, Set<String> excludeFilters, MultiMap<String, String> metadataIncludeFilters, MultiMap<String, String> metadataExcludeFilters, IBuildInfo buildInfo) {
        LogUtil.CLog.d((String)"Initializing ModuleRepo\nShards:%d\nTests Dir:%s\nABIs:%s\nDevice Tokens:%s\nTest Args:%s\nModule Args:%s\nIncludes:%s\nExcludes:%s", (Object[])new Object[]{totalShards, testsDir.getAbsolutePath(), abis, deviceTokens, testArgs, moduleArgs, includeFilters, excludeFilters});
        this.mInitialized = true;
        this.mTotalShards = totalShards;
        this.mShardIndex = shardIndex;
        Iterator<String> iterator = lock;
        synchronized (iterator) {
            if (this.mTokenModuleScheduled == null) {
                this.mTokenModuleScheduled = new HashSet<IModuleDef>();
            }
        }
        for (String line : deviceTokens) {
            String[] parts = line.split(":");
            if (parts.length == 2) {
                String key = parts[0];
                String value = parts[1];
                Set<String> list = this.mDeviceTokens.get(key);
                if (list == null) {
                    list = new HashSet<String>();
                    this.mDeviceTokens.put(key, list);
                }
                list.add(value);
                continue;
            }
            throw new IllegalArgumentException(String.format("Could not parse device token: %s", line));
        }
        ModuleRepo.putArgs(testArgs, this.mTestArgs);
        ModuleRepo.putArgs(moduleArgs, this.mModuleArgs);
        this.mIncludeAll = includeFilters.isEmpty();
        this.addFilters(includeFilters, this.mIncludeFilters, abis);
        this.addFilters(excludeFilters, this.mExcludeFilters, abis);
        File[] configFiles = testsDir.listFiles(new ConfigFilter());
        if (configFiles.length == 0) {
            throw new IllegalArgumentException(String.format("No config files found in %s", testsDir.getAbsolutePath()));
        }
        HashMap<String, Integer> shardedTestCounts = new HashMap<String, Integer>();
        for (File configFile : configFiles) {
            String name = configFile.getName().replace(CONFIG_EXT, "");
            String[] pathArg = new String[]{configFile.getAbsolutePath()};
            try {
                for (IAbi abi : abis) {
                    IConfiguration config;
                    String id = AbiUtils.createId((String)abi.getName(), (String)name);
                    if (!this.shouldRunModule(id) || !this.filterByConfigMetadata(config = this.mConfigFactory.createConfigurationFromArgs(pathArg), metadataIncludeFilters, metadataExcludeFilters)) continue;
                    HashMap<String, List<String>> args = new HashMap<String, List<String>>();
                    if (this.mModuleArgs.containsKey(name)) {
                        args.putAll(this.mModuleArgs.get(name));
                    }
                    if (this.mModuleArgs.containsKey(id)) {
                        args.putAll(this.mModuleArgs.get(id));
                    }
                    this.injectOptionsToConfig(args, config);
                    List tests = config.getTests();
                    for (IRemoteTest test : tests) {
                        this.prepareTestClass(name, abi, config, test);
                    }
                    List shardedTests = tests;
                    if (shardedTests.size() > 1) {
                        shardedTestCounts.put(id, shardedTests.size());
                    }
                    for (IRemoteTest test : shardedTests) {
                        this.addModuleDef(name, abi, test, pathArg);
                    }
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(String.format("error parsing config file: %s", configFile.getName()), e);
            }
        }
        this.mExcludeFilters.clear();
        TestRunHandler.setTestRuns(new CompatibilityBuildHelper(buildInfo), shardedTestCounts);
    }

    protected void prepareTestClass(String name, IAbi abi, IConfiguration config, IRemoteTest test) throws ConfigurationException {
        String className = test.getClass().getName();
        HashMap<String, List<String>> testArgsMap = new HashMap<String, List<String>>();
        if (this.mTestArgs.containsKey(className)) {
            testArgsMap.putAll(this.mTestArgs.get(className));
        }
        this.injectOptionsToConfig(testArgsMap, config);
        this.addFiltersToTest(test, abi, name);
    }

    @VisibleForTesting
    void injectOptionsToConfig(Map<String, List<String>> optionMap, IConfiguration config) throws ConfigurationException {
        for (Map.Entry<String, List<String>> entry : optionMap.entrySet()) {
            for (String entryValue : entry.getValue()) {
                String entryName = entry.getKey();
                if (entryValue.contains(":=")) {
                    String key = entryValue.substring(0, entryValue.indexOf(":="));
                    String value = entryValue.substring(entryValue.indexOf(":=") + 2);
                    config.injectOptionValue(entryName, key, value);
                    continue;
                }
                config.injectOptionValue(entryName, entryValue);
            }
        }
    }

    private void addFilters(Set<String> stringFilters, Map<String, List<TestFilter>> filters, Set<IAbi> abis) {
        for (String filterString : stringFilters) {
            TestFilter filter = TestFilter.createFrom((String)filterString);
            String abi = filter.getAbi();
            if (abi == null) {
                for (IAbi a : abis) {
                    this.addFilter(a.getName(), filter, filters);
                }
                continue;
            }
            this.addFilter(abi, filter, filters);
        }
    }

    private void addFilter(String abi, TestFilter filter, Map<String, List<TestFilter>> filters) {
        this.getFilter(filters, AbiUtils.createId((String)abi, (String)filter.getName())).add(filter);
    }

    private List<TestFilter> getFilter(Map<String, List<TestFilter>> filters, String id) {
        List<TestFilter> fs = filters.get(id);
        if (fs == null) {
            fs = new ArrayList<TestFilter>();
            filters.put(id, fs);
        }
        return fs;
    }

    protected void addModuleDef(String name, IAbi abi, IRemoteTest test, String[] configPaths) throws ConfigurationException {
        IConfiguration config = this.mConfigFactory.createConfigurationFromArgs(configPaths);
        this.addModuleDef(new ModuleDef(name, abi, test, config.getTargetPreparers(), config.getConfigurationDescription()));
    }

    protected void addModuleDef(IModuleDef moduleDef) {
        Set<String> tokens = moduleDef.getTokens();
        if (tokens != null && !tokens.isEmpty()) {
            this.mTokenModules.add(moduleDef);
        } else {
            this.mNonTokenModules.add(moduleDef);
        }
    }

    private void addFiltersToTest(IRemoteTest test, IAbi abi, String name) {
        String moduleId = AbiUtils.createId((String)abi.getName(), (String)name);
        if (!(test instanceof ITestFilterReceiver)) {
            throw new IllegalArgumentException(String.format("Test in module %s must implement ITestFilterReceiver.", moduleId));
        }
        List<TestFilter> mdIncludes = this.getFilter(this.mIncludeFilters, moduleId);
        List<TestFilter> mdExcludes = this.getFilter(this.mExcludeFilters, moduleId);
        if (!mdIncludes.isEmpty()) {
            this.addTestIncludes((ITestFilterReceiver)test, mdIncludes, name);
        }
        if (!mdExcludes.isEmpty()) {
            this.addTestExcludes((ITestFilterReceiver)test, mdExcludes, name);
        }
    }

    @VisibleForTesting
    protected boolean filterByConfigMetadata(IConfiguration config, MultiMap<String, String> include, MultiMap<String, String> exclude) {
        HashSet filters;
        MultiMap metadata = config.getConfigurationDescription().getAllMetaData();
        boolean shouldInclude = false;
        for (String key : include.keySet()) {
            filters = new HashSet(include.get((Object)key));
            if (!metadata.containsKey((Object)key)) continue;
            filters.retainAll(metadata.get((Object)key));
            if (filters.isEmpty()) continue;
            shouldInclude = true;
            break;
        }
        if (!include.isEmpty() && !shouldInclude) {
            return false;
        }
        for (String key : exclude.keySet()) {
            filters = new HashSet(exclude.get((Object)key));
            if (!metadata.containsKey((Object)key)) continue;
            filters.retainAll(metadata.get((Object)key));
            if (filters.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldRunModule(String moduleId) {
        List<TestFilter> mdIncludes = this.getFilter(this.mIncludeFilters, moduleId);
        List<TestFilter> mdExcludes = this.getFilter(this.mExcludeFilters, moduleId);
        return (this.mIncludeAll || !mdIncludes.isEmpty()) && !this.containsModuleExclude(mdExcludes);
    }

    private void addTestIncludes(ITestFilterReceiver test, List<TestFilter> includes, String name) {
        if (test instanceof ITestFileFilterReceiver) {
            File includeFile = this.createFilterFile(name, ".include", includes);
            ((ITestFileFilterReceiver)test).setIncludeTestFile(includeFile);
        } else {
            for (TestFilter include : includes) {
                String filterTestName = include.getTest();
                if (filterTestName == null) continue;
                test.addIncludeFilter(filterTestName);
            }
        }
    }

    private void addTestExcludes(ITestFilterReceiver test, List<TestFilter> excludes, String name) {
        if (test instanceof ITestFileFilterReceiver) {
            File excludeFile = this.createFilterFile(name, ".exclude", excludes);
            ((ITestFileFilterReceiver)test).setExcludeTestFile(excludeFile);
        } else {
            for (TestFilter exclude : excludes) {
                test.addExcludeFilter(exclude.getTest());
            }
        }
    }

    private File createFilterFile(String prefix, String suffix, List<TestFilter> filters) {
        File filterFile = null;
        try (PrintWriter out = null;){
            filterFile = FileUtil.createTempFile((String)prefix, (String)suffix);
            out = new PrintWriter(filterFile);
            for (TestFilter filter : filters) {
                String filterTest = filter.getTest();
                if (filterTest == null) continue;
                out.println(filterTest);
            }
            out.flush();
        }
        filterFile.deleteOnExit();
        return filterFile;
    }

    private boolean containsModuleExclude(Collection<TestFilter> excludes) {
        for (TestFilter exclude : excludes) {
            if (exclude.getTest() != null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedList<IModuleDef> getModules(String serial, int shardIndex) {
        Collections.sort(this.mNonTokenModules, new ExecutionOrderComparator());
        List<IModuleDef> modules = this.getShard(this.mNonTokenModules, shardIndex, this.mTotalShards);
        if (modules == null) {
            modules = new LinkedList<IModuleDef>();
        }
        long estimatedTime = 0L;
        for (IModuleDef def : modules) {
            estimatedTime += def.getRuntimeHint();
        }
        Object object = lock;
        synchronized (object) {
            Set<String> tokens = this.mDeviceTokens.get(serial);
            if (tokens != null && !tokens.isEmpty()) {
                for (IModuleDef def : this.mTokenModules) {
                    if (this.mTokenModuleScheduled.contains(def) || !tokens.equals(def.getTokens())) continue;
                    modules.add(def);
                    LogUtil.CLog.d((String)"Adding %s to scheduled token", (Object[])new Object[]{def});
                    this.mTokenModuleScheduled.add(def);
                }
            }
            if (this.mInitCount == this.mTotalShards - 1 && this.mTokenModuleScheduled.size() != this.mTokenModules.size()) {
                this.mTokenModules.removeAll(this.mTokenModuleScheduled);
                if (this.mTotalShards != 1) {
                    LogUtil.CLog.e((String)"Could not find any token for %s. Adding to last shard.", (Object[])new Object[]{this.mTokenModules});
                }
                modules.addAll(this.mTokenModules);
            }
            ++this.mInitCount;
        }
        Collections.sort(modules, new ExecutionOrderComparator());
        int uniqueCount = UniqueModuleCountUtil.countUniqueModules(modules);
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"%s running %s test sub-modules, expected to complete in %s.", (Object[])new Object[]{serial, uniqueCount, TimeUtil.formatElapsedTime((long)estimatedTime)});
        LogUtil.CLog.d((String)"module list for this shard: %s", (Object[])new Object[]{modules});
        LinkedList<IModuleDef> tests = new LinkedList<IModuleDef>();
        tests.addAll(modules);
        return tests;
    }

    protected List<IModuleDef> getShard(List<IModuleDef> fullList, int shardIndex, int totalShard) {
        List<List<IModuleDef>> res = LinearPartition.split(fullList, totalShard);
        if (res.isEmpty()) {
            return null;
        }
        if (shardIndex >= res.size()) {
            return null;
        }
        return res.get(shardIndex);
    }

    public static List<String> getModuleNamesMatching(File directory, String pattern) {
        String[] names = directory.list(new NameFilter(pattern));
        ArrayList<String> modules = new ArrayList<String>(names.length);
        for (String name : names) {
            int index = name.indexOf(CONFIG_EXT);
            if (index <= 0) continue;
            String module = name.substring(0, index);
            if (module.equals(pattern)) {
                modules = new ArrayList(1);
                modules.add(module);
                return modules;
            }
            modules.add(module);
        }
        return modules;
    }

    private static void putArgs(List<String> args, Map<String, Map<String, List<String>>> argsMap) {
        for (String arg : args) {
            List<String> valueList;
            String[] parts = arg.split(":");
            String target = parts[0];
            String name = parts[1];
            String value = parts.length == 4 ? String.format("%s:%s", parts[2], parts[3]) : parts[2];
            Map<String, List<String>> map = argsMap.get(target);
            if (map == null) {
                map = new HashMap<String, List<String>>();
                argsMap.put(target, map);
            }
            if ((valueList = map.get(name)) == null) {
                valueList = new ArrayList<String>();
                map.put(name, valueList);
            }
            valueList.add(value);
        }
    }

    @Override
    public void tearDown() {
        this.mNonTokenModules.clear();
        this.mTokenModules.clear();
        this.mIncludeFilters.clear();
        this.mExcludeFilters.clear();
        this.mTestArgs.clear();
        this.mModuleArgs.clear();
    }

    protected IConfigurationFactory getConfigFactory() {
        return this.mConfigFactory;
    }

    static {
        ENDING_MODULES.put("CtsAppSecurityHostTestCases", 1);
        ENDING_MODULES.put("CtsMonkeyTestCases", 2);
        lock = new Object();
    }

    private static class ExecutionOrderComparator
    implements Comparator<IModuleDef> {
        private ExecutionOrderComparator() {
        }

        @Override
        public int compare(IModuleDef def1, IModuleDef def2) {
            int value1 = 0;
            int value2 = 0;
            if (ENDING_MODULES.containsKey(def1.getName())) {
                value1 = (Integer)ENDING_MODULES.get(def1.getName());
            }
            if (ENDING_MODULES.containsKey(def2.getName())) {
                value2 = (Integer)ENDING_MODULES.get(def2.getName());
            }
            if (value1 == 0 && value2 == 0) {
                int time = (int)Math.signum(def1.getRuntimeHint() - def2.getRuntimeHint());
                if (time == 0) {
                    return def1.getName().compareTo(def2.getName());
                }
                return time;
            }
            return (int)Math.signum(value1 - value2);
        }
    }

    public static class ConfigFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            LogUtil.CLog.d((String)"%s/%s", (Object[])new Object[]{dir.getAbsolutePath(), name});
            return name.endsWith(ModuleRepo.CONFIG_EXT);
        }
    }

    public static class NameFilter
    implements FilenameFilter {
        private String mPattern;

        public NameFilter(String pattern) {
            this.mPattern = pattern;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.mPattern) && name.endsWith(ModuleRepo.CONFIG_EXT);
        }
    }
}

