/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.util.DynamicConfig;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class DynamicConfigFileReader {
    public static String getValueFromConfig(File file, String key) throws XmlPullParserException, IOException {
        DynamicConfig config = new DynamicConfig();
        config.initializeConfig(file);
        return config.getValue(key);
    }

    public static List<String> getValuesFromConfig(File file, String key) throws XmlPullParserException, IOException {
        DynamicConfig config = new DynamicConfig();
        config.initializeConfig(file);
        return config.getValues(key);
    }

    public static String getValueFromConfig(IBuildInfo info, String moduleName, String key) throws XmlPullParserException, IOException {
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        File dynamicConfig = helper.getDynamicConfigFiles().get(moduleName);
        if (dynamicConfig == null) {
            LogUtil.CLog.w((String)"Config file %s, not found in the map of dynamic configs.", (Object[])new Object[]{moduleName});
            return null;
        }
        return DynamicConfigFileReader.getValueFromConfig(dynamicConfig, key);
    }

    public static List<String> getValuesFromConfig(IBuildInfo info, String moduleName, String key) throws XmlPullParserException, IOException {
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        File dynamicConfig = helper.getDynamicConfigFiles().get(moduleName);
        if (dynamicConfig == null) {
            LogUtil.CLog.w((String)"Config file %s, not found in the map of dynamic configs.", (Object[])new Object[]{moduleName});
            return null;
        }
        return DynamicConfigFileReader.getValuesFromConfig(dynamicConfig, key);
    }
}

