/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.SubPlanHelper;
import com.android.compatibility.common.tradefed.testtype.ISubPlan;
import com.android.compatibility.common.tradefed.testtype.ModuleRepo;
import com.android.compatibility.common.tradefed.util.FingerprintComparisonException;
import com.android.compatibility.common.tradefed.util.OptionHelper;
import com.android.compatibility.common.tradefed.util.RetryType;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.LightInvocationResult;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.TestFilter;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.util.ArrayUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RetryFilterHelper {
    protected String mSubPlan;
    protected Set<String> mIncludeFilters = new HashSet<String>();
    protected Set<String> mExcludeFilters = new HashSet<String>();
    protected String mAbiName = null;
    protected String mModuleName = null;
    protected String mTestName = null;
    protected RetryType mRetryType = null;
    private CompatibilityBuildHelper mBuild = null;
    private int mSessionId;
    private Set<String> mRetryIncludes;
    private Set<String> mRetryExcludes;

    public RetryFilterHelper() {
    }

    public RetryFilterHelper(CompatibilityBuildHelper build, int sessionId) {
        this.mBuild = build;
        this.mSessionId = sessionId;
    }

    public RetryFilterHelper(CompatibilityBuildHelper build, int sessionId, String subPlan, Set<String> includeFilters, Set<String> excludeFilters, String abiName, String moduleName, String testName, RetryType retryType) {
        this(build, sessionId);
        this.mSubPlan = subPlan;
        this.mIncludeFilters.addAll(includeFilters);
        this.mExcludeFilters.addAll(excludeFilters);
        this.mAbiName = abiName;
        this.mModuleName = moduleName;
        this.mTestName = testName;
        this.mRetryType = retryType;
    }

    public void validateBuildFingerprint(ITestDevice device) throws DeviceNotAvailableException {
        String oldBuildFingerprint = new LightInvocationResult(this.getResult()).getBuildFingerprint();
        if (oldBuildFingerprint == null) {
            throw new FingerprintComparisonException("Could not find the build_fingerprint field in the result xml.");
        }
        String currentBuildFingerprint = device.getProperty("ro.build.fingerprint");
        if (!oldBuildFingerprint.equals(currentBuildFingerprint)) {
            throw new FingerprintComparisonException(String.format("Device build fingerprint must match %s to retry session %d", oldBuildFingerprint, this.mSessionId));
        }
    }

    @VisibleForTesting
    void setAllOptionsFrom(RetryFilterHelper obj) {
        this.clearOptions();
        this.mSubPlan = obj.mSubPlan;
        this.mIncludeFilters.addAll(obj.mIncludeFilters);
        this.mExcludeFilters.addAll(obj.mExcludeFilters);
        this.mAbiName = obj.mAbiName;
        this.mModuleName = obj.mModuleName;
        this.mTestName = obj.mTestName;
        this.mRetryType = obj.mRetryType;
    }

    public void clearOptions() {
        this.mSubPlan = null;
        this.mIncludeFilters.clear();
        this.mExcludeFilters.clear();
        this.mModuleName = null;
        this.mTestName = null;
        this.mRetryType = null;
        this.mAbiName = null;
    }

    public void setCommandLineOptionsFor(Object obj) {
        LightInvocationResult result = new LightInvocationResult(this.getResult());
        String retryCommandLineArgs = result.getCommandLineArgs();
        if (retryCommandLineArgs != null) {
            try {
                ArgsOptionParser parser = new ArgsOptionParser(new Object[]{obj});
                parser.parse(OptionHelper.getValidCliArgs(retryCommandLineArgs, obj));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setBuildInfoRetryCommand(IBuildInfo info) {
        LightInvocationResult result = new LightInvocationResult(this.getResult());
        String retryCommandLineArgs = result.getCommandLineArgs();
        new CompatibilityBuildHelper(info).setRetryCommandLineArgs(retryCommandLineArgs);
    }

    public IInvocationResult getResult() {
        IInvocationResult result = null;
        try {
            result = ResultHandler.findResult((File)this.mBuild.getResultsDir(), (Integer)this.mSessionId);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not find session with id %d", this.mSessionId));
        }
        return result;
    }

    public void populateRetryFilters() {
        this.mRetryIncludes = new HashSet<String>(this.mIncludeFilters);
        this.mRetryExcludes = new HashSet<String>(this.mExcludeFilters);
        if (RetryType.CUSTOM.equals((Object)this.mRetryType)) {
            HashSet<String> customIncludes = new HashSet<String>(this.mIncludeFilters);
            HashSet<String> customExcludes = new HashSet<String>(this.mExcludeFilters);
            if (this.mSubPlan != null) {
                ISubPlan retrySubPlan = SubPlanHelper.getSubPlanByName(this.mBuild, this.mSubPlan);
                customIncludes.addAll(retrySubPlan.getIncludeFilters());
                customExcludes.addAll(retrySubPlan.getExcludeFilters());
            }
            if (!customIncludes.isEmpty()) {
                this.mRetryIncludes.clear();
                this.mRetryIncludes.addAll(customIncludes);
                this.mRetryExcludes.addAll(customExcludes);
                return;
            }
        }
        this.mModuleName = null;
        this.mTestName = null;
        this.mSubPlan = null;
        this.populateFiltersBySubPlan();
        this.populatePreviousSessionFilters();
    }

    public void populateFiltersBySubPlan() {
        SubPlanHelper retryPlanCreator = new SubPlanHelper();
        retryPlanCreator.setResult(this.getResult());
        if (RetryType.FAILED.equals((Object)this.mRetryType)) {
            retryPlanCreator.addResultType("failed");
        } else if (RetryType.NOT_EXECUTED.equals((Object)this.mRetryType)) {
            retryPlanCreator.addResultType("not_executed");
        } else {
            retryPlanCreator.addResultType("failed");
            retryPlanCreator.addResultType("not_executed");
        }
        try {
            ISubPlan retryPlan = retryPlanCreator.createSubPlan(this.mBuild);
            this.mRetryIncludes.addAll(retryPlan.getIncludeFilters());
            this.mRetryExcludes.addAll(retryPlan.getExcludeFilters());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to create subplan for retry", e);
        }
    }

    private void populatePreviousSessionFilters() {
        RetryFilterHelper tmpHelper = new RetryFilterHelper(this.mBuild, this.mSessionId);
        tmpHelper.setAllOptionsFrom(this);
        this.setCommandLineOptionsFor(this);
        this.mRetryIncludes.addAll(this.mIncludeFilters);
        this.mRetryExcludes.addAll(this.mExcludeFilters);
        if (this.mSubPlan != null) {
            ISubPlan retrySubPlan = SubPlanHelper.getSubPlanByName(this.mBuild, this.mSubPlan);
            this.mRetryIncludes.addAll(retrySubPlan.getIncludeFilters());
            this.mRetryExcludes.addAll(retrySubPlan.getExcludeFilters());
        }
        if (this.mModuleName != null) {
            try {
                List<String> modules = ModuleRepo.getModuleNamesMatching(this.mBuild.getTestsDir(), this.mModuleName);
                if (modules.size() == 0) {
                    throw new IllegalArgumentException(String.format("No modules found matching %s", this.mModuleName));
                }
                if (modules.size() > 1) {
                    throw new IllegalArgumentException(String.format("Multiple modules found matching %s:\n%s\nWhich one did you mean?\n", this.mModuleName, ArrayUtil.join((String)"\n", (Object[])new Object[]{modules})));
                }
                String module = modules.get(0);
                RetryFilterHelper.cleanFilters(this.mRetryIncludes, module);
                RetryFilterHelper.cleanFilters(this.mRetryExcludes, module);
                this.mRetryIncludes.add(new TestFilter(this.mAbiName, module, this.mTestName).toString());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else if (this.mTestName != null) {
            throw new IllegalArgumentException("Test name given without module name. Add --module <module-name>");
        }
        this.setAllOptionsFrom(tmpHelper);
    }

    private static void cleanFilters(Set<String> filters, String module) {
        HashSet<String> cleanedFilters = new HashSet<String>();
        for (String filter : filters) {
            if (!module.equals(TestFilter.createFrom((String)filter).getName())) continue;
            cleanedFilters.add(filter);
        }
        filters.clear();
        filters.addAll(cleanedFilters);
    }

    public Set<String> getIncludeFilters() {
        return new HashSet<String>(this.mRetryIncludes);
    }

    public Set<String> getExcludeFilters() {
        return new HashSet<String>(this.mRetryExcludes);
    }

    public void tearDown() {
        this.clearOptions();
        this.mRetryIncludes = null;
        this.mRetryExcludes = null;
    }
}

